/*
 * Decompiled with CFR 0.152.
 */
package pymo.records;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import pymo.dataBases.DataBase;
import pymo.panels.MOToolBar;
import pymo.records.RecordDialog;
import pymo.security.FilePath;
import pyware.toolkit.Utils;

public class NavigatorBar
extends MOToolBar {
    private RecordDialog _$7450;
    private Frame _$7451;
    private DataBase _$7307;
    private JButton _$17587 = new JButton();
    private JButton _$12447 = new JButton();
    private JButton _$12446 = new JButton();
    private JButton _$17588 = new JButton();
    private JButton _$6702 = new JButton();
    private JButton _$15988 = new JButton();
    private JButton _$17589 = new JButton();

    public NavigatorBar() {
        try {
            this._$550();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public NavigatorBar(Frame mainFrame, RecordDialog ownerDialog, DataBase dataBase) {
        this();
        this._$7450 = ownerDialog;
        this._$7451 = mainFrame;
        this._$7307 = dataBase;
    }

    private void _$550() throws Exception {
        this._$17587.setToolTipText("Save and jump to first record.");
        this._$17587.setActionCommand("first");
        this._$17587.setIcon(new ImageIcon(FilePath.toImages("StepBack24.gif")));
        this._$17587.setBorderPainted(false);
        this._$17587.setFocusPainted(false);
        this._$17587.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                NavigatorBar.this.processDirectionClicked(e2);
            }
        });
        this._$12447.setToolTipText("Save and jump to previous record.");
        this._$12447.setActionCommand("previous");
        this._$12447.setIcon(new ImageIcon(FilePath.toImages("Rewind24.gif")));
        this._$12447.setBorderPainted(false);
        this._$12447.setFocusPainted(false);
        this._$12447.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                NavigatorBar.this.processDirectionClicked(e2);
            }
        });
        this._$12446.setToolTipText("Save and jump to next record.");
        this._$12446.setActionCommand("next");
        this._$12446.setIcon(new ImageIcon(FilePath.toImages("Play24.gif")));
        this._$12446.setBorderPainted(false);
        this._$12446.setFocusPainted(false);
        this._$12446.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                NavigatorBar.this.processDirectionClicked(e2);
            }
        });
        this._$17588.setToolTipText("Save and jump to last record.");
        this._$17588.setActionCommand("last");
        this._$17588.setIcon(new ImageIcon(FilePath.toImages("StepForward24.gif")));
        this._$17588.setBorderPainted(false);
        this._$17588.setFocusPainted(false);
        this._$17588.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                NavigatorBar.this.processDirectionClicked(e2);
            }
        });
        this._$6702.setToolTipText("Don't save changes and exit.");
        this._$6702.setActionCommand("cancel");
        this._$6702.setIcon(new ImageIcon(FilePath.toImages("Undo24.gif")));
        this._$6702.setBorderPainted(false);
        this._$6702.setFocusPainted(false);
        this._$6702.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                NavigatorBar.this.processCancelClicked(e2);
            }
        });
        this._$15988.setEnabled(false);
        this._$15988.setToolTipText("Save changes and exit");
        this._$15988.setActionCommand("save");
        this._$15988.setIcon(new ImageIcon(FilePath.toImages("Save24.gif")));
        this._$15988.setBorderPainted(false);
        this._$15988.setFocusPainted(false);
        this._$15988.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                if (NavigatorBar.this.processSaveClicked(e2)) {
                    NavigatorBar.this._$7450.hide();
                }
            }
        });
        this._$17589.setToolTipText("Delete this record.");
        this._$17589.setActionCommand("trash");
        this._$17589.setIcon(new ImageIcon(FilePath.toImages("Delete24.gif")));
        this._$17589.setBorderPainted(false);
        this._$17589.setFocusPainted(false);
        this._$17589.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                NavigatorBar.this.processTrashClicked(e2);
            }
        });
        this.centerArea.add((Component)this._$17587, null);
        this.centerArea.add((Component)this._$12447, null);
        this.centerArea.add((Component)this._$12446, null);
        this.centerArea.add((Component)this._$17588, null);
        this.leftSide.add((Component)this._$15988, null);
        this.leftSide.add((Component)this._$17589, null);
        this.rightSide.add((Component)this._$6702, null);
    }

    private void _$17594() {
        try {
            int index = this._$7450.getCurrentRecordIndex();
            long id = this._$7307.getSelectedRecords().idAt(index);
            this._$7307.deleteRecord(id);
            if (!this._$7307.isSelectedIndexValid(index)) {
                index = this._$7307.getTotalSelectedRecords() - 1;
            }
            if (index > -1) {
                this._$7450.recordToDialog(index);
            }
        }
        catch (IOException e12) {
            Utils.showErrorMessage(this._$7451, e12, "Error deleting record.");
        }
        if (this._$7307.getTotalSelectedRecords() == 0 | this._$7450.getEditMode() == RecordDialog.NEW_RECORD) {
            this._$7450.hide();
        }
    }

    void processTrashClicked(ActionEvent e2) {
        int rslt = JOptionPane.showConfirmDialog(this._$7451, "Okay to delete this record?", "Delete Record", 0, 3);
        if (rslt == 1) {
            return;
        }
        this._$17594();
    }

    void processCancelClicked(ActionEvent e2) {
        this.cancelClicked();
    }

    boolean processSaveClicked(ActionEvent e2) {
        block3: {
            try {
                if (!this._$7450.isChanged()) break block3;
                if (this._$7450.validateValues()) {
                    this._$7450.dialogToRecord();
                    break block3;
                }
                return false;
            }
            catch (IOException e12) {
                Utils.showErrorMessage(this._$7451, e12, "Error saving record changes.");
                return false;
            }
        }
        return true;
    }

    void processDirectionClicked(ActionEvent e2) {
        this.processSaveClicked(e2);
        try {
            int nextIndex = 0;
            if (e2.getActionCommand().equals("next")) {
                nextIndex = this._$7450.getCurrentRecordIndex() + 1;
            } else if (e2.getActionCommand().equals("previous")) {
                nextIndex = this._$7450.getCurrentRecordIndex() - 1;
            } else if (e2.getActionCommand().equals("last")) {
                nextIndex = this._$7307.getTotalSelectedRecords() - 1;
            }
            if (this._$7307.isSelectedIndexValid(nextIndex)) {
                this._$7450.recordToDialog(nextIndex);
            } else {
                this.getToolkit().beep();
            }
        }
        catch (IOException e22) {
            Utils.showErrorMessage(this._$7451, e22, "Error traversing records.");
        }
    }

    public boolean cancelClicked() {
        if (this._$7450.isChanged()) {
            int rslt = JOptionPane.showConfirmDialog(this._$7451, "Save changes before closing this record?", "Close Record", 1, 3);
            if (rslt == 0) {
                this.processSaveClicked(null);
            }
            if (rslt == 2) {
                return false;
            }
            if (rslt == 1) {
                if (this._$7450.getEditMode() == RecordDialog.NEW_RECORD) {
                    this._$17594();
                }
            }
        } else if (this._$7450.getEditMode() == RecordDialog.NEW_RECORD) {
            this._$17594();
        }
        this._$7450.hide();
        return true;
    }

    public void setSaveEnabled(boolean enable) {
        this._$15988.setEnabled(enable);
    }

    public void setEnabledForNewRecord() {
        this._$17587.setEnabled(false);
        this._$12446.setEnabled(false);
        this._$12447.setEnabled(false);
        this._$17588.setEnabled(false);
        this._$6702.setEnabled(false);
    }

    public JButton getDefaultButton() {
        return this._$15988;
    }
}

