/*
 * Decompiled with CFR 0.152.
 */
package pymo.records;

import java.io.IOException;
import java.util.Vector;
import pymo.dataBases.DataBase;
import pymo.fields.Field;
import pymo.records.Record;
import pymo.records.RecordEvent;
import pymo.records.RecordListener;
import pymo.records.RecordManager;

public class RecordList
extends Vector {
    RecordManager recordManager;
    private Vector _$7407 = new Vector();

    public RecordList(RecordManager recordManager) {
        this.recordManager = recordManager;
    }

    Record recordAt(int index) {
        try {
            return (Record)this.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    Record open(int index) throws IOException {
        Record record = this.recordAt(index);
        this.recordManager.open(record);
        return record;
    }

    void addRecordQuietly(Record record) {
        this.addElement(record);
    }

    public void checkIntegrity() throws Exception {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            long testID = this.recordAt(i2).getRecordID();
            for (int j2 = i2 + 1; j2 < this.size(); ++j2) {
                if (this.recordAt(j2).getRecordID() != testID) continue;
                throw new Exception("Duplicate Record ID.");
            }
        }
    }

    public boolean indexValid(int index) {
        if (index < 0) {
            return false;
        }
        return index < this.size();
    }

    public long idAt(int index) {
        return this.recordAt(index).getRecordID();
    }

    public int indexOf(long recordID) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            Record record = this.recordAt(i2);
            if (record.getRecordID() != recordID) continue;
            return i2;
        }
        return -1;
    }

    public void setList(Vector list) {
        this.removeAllElements();
        if (list != null) {
            this.addAll(list);
        }
        this.dispatchListChanged();
    }

    public void addRecord(Record record) {
        this.addRecordQuietly(record);
        this.dispatchRecordAdded(record);
    }

    public void deleteRecord(long id) throws IOException {
        int index = this.indexOf(id);
        if (index != -1) {
            Record record = this.recordAt(index);
            this.recordManager.delete(record);
            this.removeElementAt(index);
            this.dispatchRecordDeleted(record, index);
        }
    }

    public Field getField(int recordIndex, int fieldIndex) throws IOException {
        Record record = this.open(recordIndex);
        if (record == null) {
            throw new IOException("Record index out of bounds.");
        }
        return record.getFieldData(fieldIndex);
    }

    public void putField(int recordIndex, int fieldIndex, Field field) throws IOException {
        Record record = this.open(recordIndex);
        if (record == null) {
            throw new IOException("Record index out of bounds.");
        }
        record.putFieldData(fieldIndex, field);
        this.dispatchRecordChanged(record, recordIndex);
    }

    public int getRecordCount() {
        return this.size();
    }

    public void swap(int aIndex, int bIndex) {
        if (aIndex == bIndex) {
            return;
        }
        Record aRec = this.recordAt(aIndex);
        Record bRec = this.recordAt(bIndex);
        this.setElementAt(aRec, bIndex);
        this.setElementAt(bRec, aIndex);
    }

    public DataBase getDataBase() {
        return this.recordManager.getDataBase();
    }

    public synchronized void addListener(RecordListener listener) {
        this._$7407.addElement(listener);
    }

    public synchronized void removeListener(RecordListener listener) {
        this._$7407.removeElement(listener);
    }

    public void dispatchRecordAdded(Record record) {
        RecordEvent e2 = new RecordEvent(this, record, this.size() - 1);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((RecordListener)this._$7407.elementAt(i2)).recordAdded(e2);
        }
    }

    public void dispatchRecordChanged(Record record, int recordIndex) {
        RecordEvent e2 = new RecordEvent(this, record, recordIndex);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((RecordListener)this._$7407.elementAt(i2)).recordChanged(e2);
        }
    }

    public void dispatchRecordDeleted(Record record, int recordIndex) {
        RecordEvent e2 = new RecordEvent(this, record, recordIndex);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((RecordListener)this._$7407.elementAt(i2)).recordDeleted(e2);
        }
    }

    public void dispatchListChanged() {
        RecordEvent e2 = new RecordEvent(this);
        for (int i2 = 0; i2 < this._$7407.size(); ++i2) {
            ((RecordListener)this._$7407.elementAt(i2)).listChanged(e2);
        }
    }
}

