/*
 * Decompiled with CFR 0.152.
 */
package pymo.reports.labelWizard;

import java.awt.Font;
import java.awt.event.KeyEvent;
import javax.swing.JTextArea;

class TextLayout
extends JTextArea {
    public TextLayout() {
        this.setFont(new Font("Monospaced", 1, 12));
    }

    public int findLeftBracket() {
        String str = this.getText();
        for (int start = this.getCaret().getMark() - 1; start > 0; --start) {
            if (str.charAt(start) == ']') {
                return -1;
            }
            if (str.charAt(start) != '[') continue;
            return start;
        }
        return -1;
    }

    public int findRightBracket() {
        String str = this.getText();
        int lastIndex = str.length() - 1;
        for (int start = this.getCaret().getMark(); start <= lastIndex; ++start) {
            if (str.charAt(start) == '[') {
                return -1;
            }
            if (str.charAt(start) != ']') continue;
            return start;
        }
        return -1;
    }

    public void selectFieldName() {
        int left = this.findLeftBracket();
        int right = this.findRightBracket();
        this.setSelectionStart(left);
        this.setSelectionEnd(right + 1);
    }

    public String getSeletedFieldName() {
        String txt = this.getSelectedText();
        return txt.substring(1, txt.length() - 1);
    }

    public boolean isInFieldName() {
        int right;
        int left = this.getSelectionStart();
        if (left == (right = this.getSelectionEnd())) {
            return this.findLeftBracket() < this.findRightBracket();
        }
        if (left == -1 | right == -1) {
            return false;
        }
        String txt = this.getText();
        if (txt.charAt(left) != '[') {
            return false;
        }
        return txt.charAt(right - 1) == ']';
    }

    public void processKeyEvent(KeyEvent e2) {
        if (!this.isInFieldName()) {
            super.processKeyEvent(e2);
        } else if (e2.getKeyCode() == 127 | e2.getKeyCode() == 8) {
            super.processKeyEvent(e2);
        }
    }
}

