/*
 * Decompiled with CFR 0.152.
 */
package pymo.searcher;

import java.io.IOException;
import pymo.dataBases.DataBase;
import pymo.descriptors.DBChildDescriptor;
import pymo.descriptors.DBParentDescriptor;
import pymo.fields.Field;
import pymo.records.RecordList;
import pymo.searcher.SearchItem;
import pymo.searcher.SearchModel;
import pymo.searcher.Searcher;

public class IndexSearcher
extends Searcher {
    public IndexSearcher(DataBase dataBase) throws IOException {
        super(dataBase);
    }

    public RecordList findChildrenOf(String relationship, long parentRecordID) throws Exception {
        DBChildDescriptor childDescriptor = (DBChildDescriptor)this.dataBase.getDescriptors().getNamedDescriptor(relationship);
        if (childDescriptor == null) {
            throw new Exception("No children relationship descriptor in parent database.");
        }
        DataBase childrenBase = this.dataBase.getDataBaseManager().getDataBase(childDescriptor.getChildDBID());
        if (childrenBase == null) {
            throw new Exception("Children database not opened.");
        }
        DBParentDescriptor parentDescriptor = (DBParentDescriptor)this.dataBase.getDescriptors().getNamedDescriptor(relationship);
        long parentIDDescriptorID = parentDescriptor.getID();
        SearchModel model = new SearchModel();
        Field field = parentDescriptor.toField(new Long(parentRecordID));
        model.addSearchItem(new SearchItem(parentIDDescriptorID, SearchItem.COMPARE_EQUAL, field));
        return this.linearSearch(childrenBase.getRecords(), model);
    }

    public int findParentOf(String relationship, long parentRecordID) throws Exception {
        DBParentDescriptor parentDescriptor = (DBParentDescriptor)this.dataBase.getDescriptors().getNamedDescriptor(relationship);
        if (parentDescriptor == null) {
            throw new Exception("No parent relationship descriptor in the children data base");
        }
        DataBase parentBase = this.dataBase.getDataBaseManager().getDataBase(parentDescriptor.getParentDBID());
        if (parentBase == null) {
            throw new Exception("Parent database not opened.");
        }
        return parentBase.getRecords().indexOf(parentRecordID);
    }
}

