/*
 * Decompiled with CFR 0.152.
 */
package pymo.security;

import java.sql.Timestamp;
import pymo.security.Constants;
import pyware.toolkit.KeyCodeFactory;

public class EncryptChecker {
    public static String UNIVERSAL_ID = "000";
    private String _$14637 = "";
    private String _$14638 = "";
    private String _$14639 = "";
    private String _$14006 = "";
    private boolean _$14640 = false;

    public EncryptChecker() {
    }

    public EncryptChecker(String organization, String code, String seed) {
        this._$14638 = organization.toUpperCase().trim();
        this._$14639 = code.toUpperCase().trim();
        this._$14006 = seed;
    }

    private String _$14641(String encCode) {
        encCode = encCode.toUpperCase().trim();
        String str = "...";
        try {
            int len = encCode.length();
            str = encCode.substring(len - 3, len);
            str.replace('0', 'O');
            if (str.length() != 3) {
                return "...";
            }
        }
        catch (Exception e2) {
            return "...";
        }
        return str;
    }

    public String sanitizeSN(String encCode) {
        encCode = encCode.toUpperCase().trim();
        String str = "00000";
        try {
            int dash1 = encCode.indexOf(45);
            str = encCode.substring(0, dash1);
            str.replace('O', '0');
        }
        catch (Exception e2) {
            return "00000";
        }
        return str;
    }

    public String sanitizeSN() {
        return this.sanitizeSN(this._$14639);
    }

    public String stripLeadingN() {
        String aSN = this.sanitizeSN();
        if (aSN.startsWith("N")) {
            return aSN.substring(1, aSN.length());
        }
        return aSN;
    }

    private String _$14646(String encCode) {
        int pos1 = (encCode = encCode.toUpperCase().trim()).indexOf("-X");
        if (pos1 == -1) {
            return "";
        }
        int pos2 = encCode.indexOf(45, pos1 + 1);
        if (pos2 == -1) {
            return "";
        }
        return 'X' + encCode.substring(pos1 + 2, pos2).replace('O', '0');
    }

    private String _$14650(String encCode) {
        int pos1 = (encCode = encCode.toUpperCase().trim()).indexOf("-M");
        if (pos1 == -1) {
            return "";
        }
        int pos2 = encCode.indexOf(45, pos1 + 1);
        if (pos2 == -1) {
            return "";
        }
        return 'M' + encCode.substring(pos1 + 2, pos2).replace('O', '0');
    }

    private String _$14651(String encCode) {
        int pos1 = (encCode = encCode.toUpperCase().trim()).indexOf("-H");
        if (pos1 == -1) {
            return "";
        }
        int pos2 = encCode.indexOf(45, pos1 + 1);
        if (pos2 == -1) {
            return "";
        }
        return 'H' + encCode.substring(pos1 + 2, pos2);
    }

    private String _$14652(String encCode) {
        int pos1 = (encCode = encCode.toUpperCase().trim()).indexOf("-K");
        if (pos1 == -1) {
            return "";
        }
        int pos2 = encCode.indexOf(45, pos1 + 1);
        if (pos2 == -1) {
            return "";
        }
        return 'K' + encCode.substring(pos1 + 2, pos2).replace('O', '0');
    }

    public long getInstallationDDate(String encCode) {
        String exp = this._$14652(encCode);
        int len = exp.length();
        String startStr = exp.substring(1, len - 2);
        String totalStr = exp.substring(len - 2, len);
        long startDay = Long.parseLong(startStr, 16) + KeyCodeFactory.DAYS_BEFORE_2002;
        long totalDays = Long.parseLong(totalStr, 16) * 2L;
        long startMSec = startDay * KeyCodeFactory.MSEC_PER_DAY;
        long totalMSec = totalDays * KeyCodeFactory.MSEC_PER_DAY;
        return startMSec + totalMSec;
    }

    public String getInstallationDDate() {
        return Long.toString(this.getInstallationDDate(this._$14639));
    }

    public boolean hasInstallationExpiration() {
        String exp = this._$14652(this._$14639);
        return exp.length() > 0;
    }

    public String getServerID() {
        String pfx = this._$14651(this._$14639);
        if (pfx.length() <= 1) {
            return "";
        }
        if (pfx.endsWith(".")) {
            pfx = pfx.substring(0, pfx.length() - 1);
        }
        return pfx.substring(1);
    }

    public boolean isServerAccessEnabled() {
        return this.isServerAccessEnabled(this._$14639);
    }

    public boolean isServerAccessEnabled(String encCode) {
        String pfx = this._$14651(encCode);
        return !pfx.startsWith("HX");
    }

    private boolean _$14661(String encCode) {
        String str = this.sanitizeSN(encCode = encCode.toUpperCase().trim());
        int len = str.length();
        if (len > 0) {
            return str.charAt(0) == 'N';
        }
        return false;
    }

    private boolean _$14662(String expiration) {
        if (expiration.length() == 0) {
            return false;
        }
        int len = expiration.length();
        long days = Long.parseLong(expiration.substring(len - 2, len), 16);
        long startDay = Long.parseLong(expiration.substring(1, len - 2), 16) + Constants.DAYS_BEFORE_2002;
        long stopDay = startDay + days;
        Timestamp startStamp = new Timestamp(startDay * Constants.MILLIS_PER_DAY);
        Timestamp stopStamp = new Timestamp(stopDay * Constants.MILLIS_PER_DAY);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        return now.before(startStamp) | now.after(stopStamp);
    }

    private boolean _$3435(String computerID) {
        if (computerID.length() == 0) {
            return true;
        }
        if (computerID.startsWith('M' + UNIVERSAL_ID)) {
            return true;
        }
        return computerID.compareToIgnoreCase('M' + EncryptChecker.getActualComputerID()) == 0;
    }

    public static String getActualComputerID() {
        String str = Long.toHexString(KeyCodeFactory.charSum(System.getProperty("user.name", "")) + KeyCodeFactory.charSum(System.getProperty("os.name", "")) + KeyCodeFactory.charSum(System.getProperty("os.arch", "")));
        return str.toUpperCase();
    }

    public boolean isUniversalIDEntered() {
        return this._$14640;
    }

    public boolean isValid(String organization, String encCode) {
        encCode = encCode.toUpperCase().trim();
        String name = KeyCodeFactory.sanitizeName(organization);
        String sn = this.sanitizeSN(encCode);
        String key = this._$14641(encCode);
        String keyExpiration = this._$14646(encCode);
        String computerID = this._$14650(encCode);
        this._$14640 = computerID.startsWith('M' + UNIVERSAL_ID);
        String operatingDays = this._$14652(encCode);
        String hostPrefix = this._$14651(encCode);
        if (this._$14662(keyExpiration)) {
            this._$14637 = "Activation code has expired.";
            return false;
        }
        if (!this._$3435(computerID)) {
            this._$14637 = "Incorrect computer ID.";
            return false;
        }
        int sum = KeyCodeFactory.charSum(sn) + KeyCodeFactory.charSum(keyExpiration) + KeyCodeFactory.charSum(operatingDays) + KeyCodeFactory.charSum(computerID) + KeyCodeFactory.charSum(hostPrefix) + KeyCodeFactory.charSum(this._$14006);
        if (!this._$14661(encCode)) {
            sum += KeyCodeFactory.charSum(name);
        }
        String testKey = KeyCodeFactory.makeKey(sum);
        key = '-' + key;
        if (!key.equals(testKey)) {
            this._$14637 = "Incorrect licensee name or activation code.";
            return false;
        }
        this._$14637 = "";
        return true;
    }

    public static boolean doesActivationCodeExpire(String activationCode) {
        return activationCode.toUpperCase().indexOf("-X") != -1;
    }

    public boolean isValid() {
        return this.isValid(this._$14638, this._$14639);
    }

    public String getValidationErrorMsg() {
        return this._$14637;
    }
}

