/*
 * Decompiled with CFR 0.152.
 */
package pymo.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import pymo.security.Constants;

public class FilePath {
    public static String toWorkingDir() {
        return System.getProperty("user.dir", ".");
    }

    public static String toWorkingDir(String fileName) {
        return FilePath.toWorkingDir() + File.separator + fileName;
    }

    public static String toSystemDir() {
        return System.getProperty("user.home", ".");
    }

    public static String toMessageFile() {
        return "messages" + File.separator + "messages.ini";
    }

    public static String toMessages(String fileName) {
        return "messages" + File.separator + fileName;
    }

    public static String toSettingsFile() {
        return "lib/settings" + File.separator + "settings.txt";
    }

    public static String toInitialSettingsFile() {
        return "lib/settings" + File.separator + "init.txt";
    }

    public static String toSettings(String fileName) {
        return "lib/settings" + File.separator + fileName;
    }

    public static String toDataFiles() {
        return Constants.LOCAL_DATA_FILES_DIR + File.separator;
    }

    public static String toDataFiles(String fileName) {
        return Constants.LOCAL_DATA_FILES_DIR + File.separator + fileName;
    }

    public static String toTemplates() {
        return "lib/templates" + File.separator;
    }

    public static String toTemplates(String fileName) {
        return "lib/templates" + File.separator + fileName;
    }

    public static String toImages() {
        return "lib/images" + File.separator;
    }

    public static String toImages(String fileName) {
        return "lib/images" + File.separator + fileName;
    }

    public static String appendFileName(String path, String fileName) {
        if (path.endsWith(File.separator)) {
            return path + fileName;
        }
        return path + File.separator + fileName;
    }

    public static boolean hasSuffix(String path, String sfx) {
        if (path == null) {
            return false;
        }
        if (sfx == null) {
            return false;
        }
        if (!sfx.startsWith(".")) {
            sfx = "." + sfx;
        }
        return path.toLowerCase().endsWith(sfx.toLowerCase());
    }

    public static String appendSuffix(String path, String sfx) {
        if (path == null) {
            return null;
        }
        if (sfx == null) {
            return path;
        }
        if (!sfx.startsWith(".")) {
            sfx = "." + sfx;
        }
        if (!path.toLowerCase().endsWith(sfx.toLowerCase())) {
            return path + sfx;
        }
        return path;
    }

    public static String removeSuffix(String path, String sfx) {
        if (path == null) {
            return null;
        }
        if (sfx == null) {
            return path;
        }
        if (!sfx.startsWith(".")) {
            sfx = "." + sfx;
        }
        if (path.toLowerCase().endsWith(sfx.toLowerCase())) {
            return path.substring(0, path.length() - sfx.length());
        }
        return path;
    }

    public static boolean isValid(String path) {
        File f2 = new File(path);
        return f2.isFile();
    }

    public static boolean isDir(String path) {
        File f2 = new File(path);
        return f2.isDirectory();
    }

    public static void eraseFile(String path) {
        File f2 = new File(path);
        f2.delete();
    }

    public static String extractFileName(String path) {
        File f2 = new File(path);
        return f2.getName();
    }

    public static String extractPath(String path) {
        File f2 = new File(path);
        int pos = path.indexOf(f2.getName());
        if (pos <= 0) {
            return path;
        }
        return path.substring(0, pos - 1);
    }

    public static String[] getFileList(String path) {
        File f2 = new File(FilePath.appendFileName(path, "."));
        if (f2.list() == null) {
            return new String[0];
        }
        return f2.list();
    }

    public void transferFile(File sourceFile, String destinationPath) {
        if (sourceFile.isHidden()) {
            return;
        }
        if (sourceFile.getName().compareToIgnoreCase(".DS_Store") == 0) {
            return;
        }
        String child = sourceFile.getName();
        File destFile = new File(destinationPath, child);
        if (!destFile.exists()) {
            sourceFile.renameTo(destFile);
        }
    }

    public void transferDirectory(String directoryPath, String destinationPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            return;
        }
        File[] fileList = directory.listFiles();
        for (int i2 = 0; i2 < fileList.length; ++i2) {
            File aFile = fileList[i2];
            if (!aFile.isFile()) continue;
            this.transferFile(aFile, destinationPath);
        }
    }

    public static boolean compareFiles(String file1, String file2) {
        FileInputStream in1 = null;
        FileInputStream in2 = null;
        try {
            if (new File(file1).length() != new File(file2).length()) {
                throw new Exception();
            }
            in1 = new FileInputStream(file1);
            in2 = new FileInputStream(file2);
            byte[] buffer1 = new byte[1024];
            byte[] buffer2 = new byte[1024];
            int len1 = 0;
            while ((len1 = in1.read(buffer1)) != -1) {
                int len2 = in2.read(buffer2);
                if (len1 != len2) {
                    throw new Exception();
                }
                for (int i2 = 0; i2 < len1; ++i2) {
                    if (buffer1[i2] == buffer2[i2]) continue;
                    throw new Exception();
                }
            }
            in1.close();
            in2.close();
        }
        catch (Exception ex2) {
            try {
                if (in1 != null) {
                    in1.close();
                }
                if (in2 != null) {
                    in2.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static boolean copyFile(String source, String destination) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer);
            }
            in.close();
            out.close();
        }
        catch (Exception ex2) {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            return false;
        }
        return true;
    }
}

