/*
 * Decompiled with CFR 0.152.
 */
package pymo.security;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.JOptionPane;
import pymo.security.Constants;
import pymo.security.EncryptChecker;
import pyware.toolkit.FileUtils;
import pyware.toolkit.IniFile;

public class Settings
extends IniFile {
    public static int PRINT_RESTRICTION = 0;
    public static int FTP_RESTRICTION = 1;
    public static int REQUIRED_CD_TO_INSTALL = 0;
    public static int REQUIRED_CD_TO_RUN = 1;
    public static int FTP_INVALID_INSTALL_CHECK = 2;
    public static int STANDARD_OPERATING_MODE = 0;
    public static int VIEWER_OPERATING_MODE = 1;
    public static int DRILL_PLAYER_OPERATING_MODE = 2;
    public static int DESIGNER_CD_OPERATING_MODE = 3;
    public static int NO_ENCRYPTOR = 0;
    public static int VIEWER_ENCRYPTOR = 1;
    public static int INSTALLATION_ENCRYPTOR = 2;
    public static int VERSION1_ENCRYPTOR = 3;
    private static int _$6000 = 0;
    private static int _$6001 = 1;
    private boolean _$6002 = false;
    private boolean _$6003 = false;
    private boolean _$6004 = false;
    Vector settingsListListener = new Vector();

    public Settings() {
        this._$6004 = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    }

    public Settings(String aPath) {
        this();
        try {
            this.load(aPath);
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
    }

    public Settings(String aPath, String aInitialPath) {
        this();
        File aFile;
        if (!FileUtils.isValid(aPath)) {
            if (FileUtils.isValid(aInitialPath)) {
                aFile = new File(aInitialPath);
                aFile.renameTo(new File(aPath));
            }
        } else if (FileUtils.isValid(aInitialPath)) {
            aFile = new File(aInitialPath);
            aFile.delete();
        }
        try {
            this.load(aPath);
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
    }

    public void trySave() {
        try {
            this.save();
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
    }

    private int _$6013(String str) {
        int len = str.length();
        int sum = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            sum += (byte)str.charAt(i2) * (i2 + 1);
        }
        return sum;
    }

    private String _$6016() {
        int s1 = this._$6013(this.getLine("Licensing", "Name", "untitled"));
        int s2 = this._$6013(this.getLine("Licensing", "SN", "xxxxx"));
        int s3 = this._$6013(this.getLine("Licensing", "SNPrefix", "xxxx"));
        int s4 = this._$6013(this.getLine("Licensing", "Encryptor", "0"));
        int s5 = this._$6013(this.getLine("Licensing", "Restrictions", "xxxxxxxx"));
        int s6 = this._$6013(this.getLine("Licensing", "Security", "xxxxxxxx"));
        int s7 = this._$6013(this.getLine("Licensing", "InstallDate", "date"));
        int s8 = this._$6013(this.getLine("Licensing", "DDate", "date"));
        int s9 = this._$6013(this.getLine("Licensing", "ComputerID", "xxx"));
        int s10 = this._$6013(this.getLine("Licensing", "BlockDate", ""));
        int tot = s1 + s2 + s3 + s4 + s5 + s6 + s7 + s8 + s9 + s10;
        char ch1 = (char)new Long(Math.round((double)tot * 1.2) % 26L + 65L).byteValue();
        char ch2 = (char)new Long(Math.round((double)tot * 1.4) % 26L + 65L).byteValue();
        char ch3 = (char)new Long(Math.round((double)tot * 1.8) % 26L + 65L).byteValue();
        return "" + ch1 + ch2 + ch3;
    }

    public int getIniFileVersion() {
        return this.getIntLine("Version", "Ini File", 0);
    }

    public void createVersionFile() {
        this.setIntLine("Version", "AppMinorMinor", Constants.APPLICATION_MINOR_MINOR_VERSION);
        this.setIntLine("Version", "AppMinor", Constants.APPLICATION_MINOR_VERSION);
        this.setIntLine("Version", "AppMajor", Constants.APPLICATION_MAJOR_VERSION);
        this.setLine("Version", "AppVer", Constants.APPLICATION_VERSION_DESCRIPTION);
        this.setLine("Version", "AppPaddedVer", Constants.APPLICATION_PADDED_VERSION);
        this.setIntLine("Version", "BetaBuild", Constants.BETA_BUILD);
        IniFile stub = new IniFile(this.getProdCode() + ".ver.txt");
        String[] vers = this.getSectionList("Version");
        for (int i2 = 0; i2 < vers.length; ++i2) {
            stub.setLine("Version", vers[i2], this.getLine("Version", vers[i2], ""));
        }
        try {
            stub.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isPysCopy() {
        return this.getLine("Licensing", "Name", "").toLowerCase().equals("py");
    }

    public boolean isMacintosh() {
        return this._$6004;
    }

    public String getApplicationName() {
        if (this.getOperatingMode() == STANDARD_OPERATING_MODE) {
            return Constants.APPLICATION_NAME1;
        }
        return "Unknown Application Name";
    }

    public int getOperatingMode() {
        if (Constants.STANDARD_PROD_CODES.indexOf(this.getProdCode()) != -1) {
            return STANDARD_OPERATING_MODE;
        }
        if (this.getProdCode().compareToIgnoreCase(Constants.VIEWER_PROD_CODE) == 0) {
            return VIEWER_OPERATING_MODE;
        }
        return -1;
    }

    public boolean isLicenseValid() {
        String key = this.getLine("Licensing", "Key", "...");
        return key.equals(this._$6016());
    }

    public String getProdCode() {
        return this.getLine("Licensing", "SNPrefix", "");
    }

    public String getVAR() {
        return this.getLine("Licensing", "VAR", "");
    }

    public String getSerialNumber() {
        return this.getProdCode() + "-" + this.getLine("Licensing", "SN", "");
    }

    public String getLicensedToAndSN() {
        String nameStr = this.getLicensedTo();
        String snStr = this.getLine("Licensing", "SN", "");
        snStr = !snStr.startsWith("00000") && snStr.length() != 0 ? "    Serial #" + this.getProdCode() + "-" + snStr : "";
        return nameStr + snStr;
    }

    public String getLicensedTo() {
        String nameStr = this.getLine("Licensing", "Name", "");
        if (nameStr.length() == 0) {
            return "";
        }
        return nameStr;
    }

    public String getExpirationDate() {
        if (this.canExpire()) {
            String str = this.getLine("Licensing", "DDate", "");
            if (str.equals("0")) {
                return "(Expired Copy)";
            }
            String dateStr = new Timestamp(new Long(str)).toString();
            return "Expires " + dateStr.substring(0, 10);
        }
        return "";
    }

    public String getComputerID() {
        return this.getLine("Licensing", "ComputerID", "xxx");
    }

    public boolean canExpire() {
        String aStr = this.getLine("Licensing", "DDate", "");
        return !aStr.equals("");
    }

    public boolean expiresWithin(int days) {
        return this.isExpiredAfter(new Timestamp(System.currentTimeMillis() + (long)days * Constants.MILLIS_PER_DAY));
    }

    public boolean isExpiredAfter(Timestamp date) {
        if (!this.canExpire()) {
            return false;
        }
        if (this.isExpiredCopy()) {
            return true;
        }
        Timestamp ddate = this.getTimeStampLine("Licensing", "DDate", new Timestamp(0L));
        return ddate.before(date);
    }

    public boolean isExpiredCopy() {
        if (!this.canExpire()) {
            return false;
        }
        Timestamp ddate = this.getTimeStampLine("Licensing", "DDate", new Timestamp(0L));
        if (ddate.equals(new Timestamp(0L))) {
            return true;
        }
        if (ddate.before(new Timestamp(System.currentTimeMillis()))) {
            this.setLine("Licensing", "DDate", "0");
            this.setLicenseValid();
            this.trySave();
            return true;
        }
        return false;
    }

    public boolean isInstallDateSet() {
        String str = this.getLine("Licensing", "InstallDate", "");
        return str.length() != 0;
    }

    public boolean isInstallBlocked() {
        return this.getLine("Licensing", "BlockDate", "").compareTo("0") == 0;
    }

    public boolean isSecuritySet(int index) {
        String str = this.getLine("Licensing", "Security", "11111111");
        if (str.length() < 8) {
            return true;
        }
        return str.charAt(index) == '1';
    }

    public boolean isComputerIDValid() {
        String id = this.getComputerID();
        if (id.startsWith(EncryptChecker.UNIVERSAL_ID)) {
            return true;
        }
        if (id.length() == 0) {
            return true;
        }
        String actualID = EncryptChecker.getActualComputerID();
        return id.compareToIgnoreCase(actualID) == 0;
    }

    public boolean isRenewable() {
        return this.getIntLine("Licensing", "Install", 0) == _$6001;
    }

    public String getBlockDate() {
        return this.getTimeStampLine("Licensing", "BlockDate", new Timestamp(0L)).toString().substring(0, 10);
    }

    public void setBlockDate(int days) {
        this.setTimeStampLine("Licensing", "BlockDate", new Timestamp(System.currentTimeMillis() + (long)days * Constants.MILLIS_PER_DAY));
        this.setLicenseValid();
        this.trySave();
    }

    public boolean isBlockDateSet() {
        return this.getLongLine("Licensing", "BlockDate", 0L) > 0L;
    }

    public boolean isBlockDateExpired() {
        if (!this.isBlockDateSet()) {
            return false;
        }
        Timestamp blockDate = this.getTimeStampLine("Licensing", "BlockDate", new Timestamp(0L));
        return blockDate.before(new Timestamp(System.currentTimeMillis()));
    }

    public void setLicenseValid() {
        this.setLine("Licensing", "Key", this._$6016());
    }

    public void advanceDDate(int days) {
        this.setLine("Licensing", "DDate", new Long(System.currentTimeMillis() + Constants.MILLIS_PER_DAY * (long)days).toString());
        this.setLicenseValid();
        this.trySave();
    }

    public boolean is20thRun() {
        long run = this.getLongLine("FTP", "Run", 0L);
        this.setLongLine("FTP", "Run", run + 1L);
        return run % 20L == 0L;
    }

    public String getBlockDescription() {
        return this.getLine("FTP", "BlockDesc", "");
    }

    public void blockInstallation(String blockDesc) {
        if (this.getLine("Licensing", "BlockDate", "").compareTo("0") == 0) {
            return;
        }
        this.setLine("Licensing", "BlockDate", "0");
        this.setLine("FTP", "BlockDesc", blockDesc);
        this.setLicenseValid();
        this.trySave();
        this.setAllRestrictions(true);
    }

    public void unblockInstallation() {
        if (this.getLine("Licensing", "BlockDate", "").length() == 0) {
            return;
        }
        this.setLine("Licensing", "BlockDate", "");
        this.setLine("FTP", "BlockDesc", "");
        this.setLicenseValid();
        this.trySave();
    }

    public void askSwitchProgramToLocalOnly(Frame frame) {
        int rslt = JOptionPane.showConfirmDialog(frame, "Contact Pygraphics to extend the life of your online school account,\nor you can reset this program to operate only locally.\nWhen operating only locally, you will only be able to send and receive\nassignment information with the installations of iPAS that are\nlocated on this computer.\n\nDo you want to reset the program for local only operation?", "iPAS Online Librarian", 0, 3);
        if (rslt != 0) {
            return;
        }
        rslt = JOptionPane.showConfirmDialog(frame, "Are you sure you want to reset the program to operate only locally?", "iPAS Online Librarian", 0, 3);
        if (rslt == 0) {
            this.setRemoteFTPAccessEnabled(false);
            JOptionPane.showMessageDialog(frame, "You must restart the program for this change to take effect.", "iPAS Online Librarian", 1);
        }
    }

    public boolean isPromptShowable(String messageName) {
        return this.getBoolLine("Prompts", messageName, true);
    }

    public boolean canCheckMessages() {
        return this.getBoolLine("Display", "CheckMessages", Constants.CHECK_MESSAGES);
    }

    public boolean isMessageDelayed(String msgID) {
        Timestamp zeroDate = new Timestamp(0L);
        Timestamp date = this.getTimeStampLine("Pygraphics Messages", msgID, zeroDate);
        if (date.equals(zeroDate)) {
            return false;
        }
        return date.after(new Timestamp(System.currentTimeMillis()));
    }

    public String getRecentPath(String fileDesc, String defaultFile) {
        return this.getLine("Recent Paths", fileDesc, defaultFile);
    }

    public void resetPrompts() {
        this.removeSection("Prompts");
    }

    public void setPromptShowable(String messageName, boolean show) {
        this.setBoolLine("Prompts", messageName, show);
    }

    public void setRecentPath(String fileDesc, String fileName) {
        this.setLine("Recent Paths", fileDesc, fileName);
    }

    public void resetRecentPaths() {
        this.removeSection("Recent Paths");
    }

    public void setMessageDelay(String msgID, int days) {
        Timestamp date = new Timestamp(System.currentTimeMillis() + Constants.MILLIS_PER_DAY * (long)days);
        this.setTimeStampLine("Pygraphics Messages", msgID, date);
    }

    public boolean isUpdateDue() {
        if (!this.getBoolLine("Preferences", "CheckUpdates", true)) {
            return false;
        }
        Timestamp NextUpdate = this.getTimeStampLine("Preferences", "NextUpdate", new Timestamp(0L));
        Timestamp today = new Timestamp(System.currentTimeMillis());
        return today.after(NextUpdate);
    }

    public void setNextUpdateTime(float days) {
        if (days < 0.0f) {
            this.setBoolLine("Preferences", "CheckUpdates", false);
        } else {
            int daysMillis = new Float(days * (float)Constants.MILLIS_PER_DAY).intValue();
            this.setTimeStampLine("Preferences", "NextUpdate", new Timestamp((long)daysMillis + System.currentTimeMillis()));
        }
        this.trySave();
    }

    public String getHomeAccountName() {
        String str = this.getLine("FTP", "Account", null);
        if (str == null) {
            return null;
        }
        int pos = str.indexOf(46);
        return str.substring(pos + 1);
    }

    public String getHomeAccountID() {
        String str = this.getLine("FTP", "Account", null);
        if (str == null) {
            return null;
        }
        int pos = str.indexOf(46);
        return str.substring(0, pos);
    }

    public String getHomeAccount() {
        return FileUtils.sanatizeFTPDirName(this.getLine("FTP", "Account", null));
    }

    public void setHomeAccount(String accountID, String accountName) {
        this.setLine("FTP", "Account", accountID.trim() + '.' + accountName.trim());
    }

    public void setServerID(String id) {
        this.setLine("FTP", "SID", id);
    }

    public String getServerID() {
        return FileUtils.sanatizeFTPDirName(this.getLine("FTP", "SID", ""));
    }

    public String getLocalPath() {
        return this.getLine("FTP", "LocalPath", "");
    }

    public void setRemoteFTPAccessEnabled(boolean enabled) {
        this.setBoolLine("FTP", "RemoteAccess", enabled);
        if (!enabled) {
            this.setLine("FTP", "OfflineMirror", this.getLine("FTP", "LocalPath", "temp"));
        }
    }

    public boolean isRemoteFTPAccessEnabled() {
        return this.getBoolLine("FTP", "RemoteAccess", false);
    }

    public String getVersionDescription() {
        return this.getLine("Version", "AppVer", "0.0.0");
    }

    public boolean isAnyRestrictionSet() {
        if (this._$6002) {
            return true;
        }
        String str = this.getLine("Licensing", "Restrictions", "11111111");
        if (str.length() < 8) {
            return true;
        }
        return str.indexOf(49) > -1;
    }

    public boolean isRestrictionSet(int index) {
        if (this._$6002) {
            return true;
        }
        String str = this.getLine("Licensing", "Restrictions", "11111111");
        if (str.length() < 8) {
            return true;
        }
        return str.charAt(index) == '1';
    }

    public void setAllRestrictions(boolean allRestrictions) {
        this._$6002 = allRestrictions;
    }
}

