/*
 * Decompiled with CFR 0.152.
 */
package pymo.sorter;

import java.io.IOException;
import pymo.dataBases.DataBase;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.descriptors.DescriptorList;
import pymo.fields.Field;
import pymo.records.RecordList;
import pymo.sorter.SortItem;
import pymo.sorter.SortModel;

public class Sorter {
    private DataBase _$7307;
    private RecordList _$8632;
    private AbstractFieldDescriptor[] _$16843;
    private int[] _$16833;

    public Sorter(DataBase dataBase) throws IOException {
        this._$7307 = dataBase;
    }

    private void _$16844(SortModel sortModel) {
        DescriptorList descriptors = this._$7307.getDescriptors();
        int len = sortModel.getSortItemCount();
        this._$16843 = new AbstractFieldDescriptor[len];
        this._$16833 = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            SortItem sortItem = sortModel.sortItemAt(i2);
            this._$16843[i2] = descriptors.getFieldDescriptor(sortItem.getDescriptorID());
            this._$16833[i2] = sortItem.getDirection();
        }
    }

    public void sort(RecordList recordList, SortModel sortModel) throws IOException {
        if (sortModel.isEmpty()) {
            return;
        }
        this._$16844(sortModel);
        this._$8632 = recordList;
        this._$16845(0, recordList.getRecordCount() - 1);
        recordList.dispatchListChanged();
    }

    private Field[] _$16846(int recordIndex) throws IOException {
        Field[] fields = new Field[this._$16843.length];
        for (int i2 = 0; i2 < this._$16843.length; ++i2) {
            fields[i2] = this._$8632.getField(recordIndex, this._$16843[i2].getFieldIndex());
        }
        return fields;
    }

    private int _$9525(int lowHi, Field[] midFields) throws IOException {
        int rslt = 0;
        for (int i2 = 0; i2 < this._$16843.length; ++i2) {
            AbstractFieldDescriptor descriptor = this._$16843[i2];
            Field lowHiField = this._$8632.getField(lowHi, descriptor.getFieldIndex());
            rslt = this._$16833[i2] == SortModel.SORT_ASCENDING ? descriptor.compare(lowHiField, midFields[i2]) : descriptor.compare(midFields[i2], lowHiField);
            if (rslt == 0) continue;
            return rslt;
        }
        return 0;
    }

    private void _$16845(int first, int last) throws IOException {
        int low = first;
        int high = last;
        if (first >= last) {
            return;
        }
        Field[] midFields = this._$16846(first + last >> 1);
        while (true) {
            if (this._$9525(low, midFields) < 0) {
                ++low;
                continue;
            }
            while (this._$9525(high, midFields) > 0) {
                --high;
            }
            if (low <= high) {
                this._$8632.swap(low, high);
                ++low;
                --high;
            }
            if (low > high) break;
        }
        this._$16845(first, high);
        this._$16845(low, last);
    }
}

