/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import javax.swing.Timer;
import pyware.iPasToolkit.WavePlayerEvent;
import pyware.iPasToolkit.WavePlayerListener;
import pyware.toolkit.FileUtils;

public class WaveFilePlayer
implements Runnable {
    private static int _$1499 = 512;
    public static int STARTING = 1;
    public static int PLAYING = 2;
    public static int STOPPED = 3;
    private int _$1503 = STOPPED;
    private Thread _$1504;
    private String _$1505;
    private AudioInputStream _$1506;
    private SourceDataLine _$1507;
    private byte[] _$1508;
    private Vector _$1509 = new Vector();
    private Timer _$1510 = new Timer(35, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            WaveFilePlayer.this._$1513();
        }
    });

    private void _$1513() {
        if (this.isPlaying()) {
            this._$1515(this._$1507.getMicrosecondPosition());
        }
    }

    private void _$1517(int state) {
        this._$1503 = state;
        this._$1518(state);
    }

    private boolean _$1519() {
        return this._$1506 != null;
    }

    private void _$1520() throws Exception {
        if (this._$1519()) {
            return;
        }
        File soundFile = new File(this._$1505);
        this._$1506 = AudioSystem.getAudioInputStream(soundFile);
        AudioFormat audioFormat = this._$1506.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        this._$1507 = (SourceDataLine)AudioSystem.getLine(info);
        this._$1507.open(audioFormat);
        this._$1507.start();
        this._$1508 = new byte[_$1499];
    }

    private void _$1529() {
        if (!this._$1519()) {
            return;
        }
        try {
            this._$1506.close();
        }
        catch (IOException ex2) {
            this._$1531(ex2.getMessage());
        }
        this._$1506 = null;
        this._$1507.close();
        this._$1507 = null;
    }

    public void run() {
        this._$1517(STARTING);
        int bytesRead = 0;
        try {
            this._$1520();
            this._$1510.start();
            this._$1517(PLAYING);
            while (this._$1504 != null) {
                bytesRead = this._$1506.read(this._$1508, 0, this._$1508.length);
                if (bytesRead != -1) {
                    int n2 = this._$1507.write(this._$1508, 0, bytesRead);
                }
                if (bytesRead != -1) continue;
                this._$1507.drain();
                this._$1504 = null;
            }
        }
        catch (Exception ex2) {
            this._$1510.stop();
            this._$1531(ex2.getMessage());
        }
        if (this._$1510.isRunning()) {
            this._$1510.stop();
        }
        if (bytesRead != -1) {
            this._$1507.flush();
        }
        this._$1529();
        this._$1517(STOPPED);
    }

    public boolean isPlaying() {
        return this._$1503 == PLAYING && this._$1504 != null;
    }

    public synchronized void start() {
        if (this._$1504 != null) {
            this.stop();
        }
        this._$1504 = new Thread(this);
        this._$1504.setName("WaveFilePlayer");
        this._$1504.start();
    }

    public synchronized void stop() {
        this._$1504 = null;
    }

    public synchronized void setFileName(String fileName) throws Exception {
        if (!FileUtils.hasSuffix(fileName, "wav")) {
            fileName = FileUtils.appendSuffix(fileName, "wav");
        }
        this._$1505 = fileName;
    }

    public void setVolume(int percent) {
        SourceDataLine line = this._$1507;
        if (line == null) {
            return;
        }
        FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
        if (gainControl != null) {
            float value = (float)percent / 100.0f;
            float dB = (float)(Math.log((double)value == 0.0 ? 1.0E-4 : (double)value) / Math.log(10.0) * 20.0);
            gainControl.setValue(dB);
        }
    }

    private void _$1531(String msg) {
        WavePlayerEvent e2 = WavePlayerEvent.createErrorEvent(this, msg);
        for (int i2 = 0; i2 < this._$1509.size(); ++i2) {
            ((WavePlayerListener)this._$1509.elementAt(i2)).error(e2);
        }
    }

    private void _$1518(int state) {
        WavePlayerEvent e2 = WavePlayerEvent.createStateChangedEvent(this, state);
        for (int i2 = 0; i2 < this._$1509.size(); ++i2) {
            ((WavePlayerListener)this._$1509.elementAt(i2)).stateChanged(e2);
        }
    }

    private void _$1515(long mSec) {
        WavePlayerEvent e2 = WavePlayerEvent.createPositionChangedEvent(this, mSec);
        for (int i2 = 0; i2 < this._$1509.size(); ++i2) {
            ((WavePlayerListener)this._$1509.elementAt(i2)).positionChanged(e2);
        }
    }

    public synchronized void addListener(WavePlayerListener listener) {
        this._$1509.addElement(listener);
    }

    public synchronized void removeListener(WavePlayerListener listener) {
        this._$1509.removeElement(listener);
    }
}

