/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import pyware.toolkit.Utils;

public class EvaluationDatFile {
    static int VERSION = 2;
    int bonus = 0;
    long creationDate;
    long fill1 = 0L;
    long fill2 = 0L;
    String fullFileName = null;
    int grade;
    int gradeAttackTolerance;
    double gradeIntonationTolerance;
    int gradeMethod;
    int gradeReleaseTolerance;
    int gradeWeightIntonation;
    int gradeWeightRhythm;
    String instrument;
    long instrumentID = 0L;
    long lessonID;
    double noteAccuracy;
    String performer;
    double pitchAccuracy;
    int pitchTendency;
    double rhythmAccuracy;
    String scriptID;
    String scriptTitle;
    String sn = "";
    float tempoFactor;
    int timer = 0;
    int totalNotes;
    boolean valid = true;

    public EvaluationDatFile(String fullFileName) throws Exception {
        this.fullFileName = fullFileName;
        this.load(fullFileName);
    }

    public EvaluationDatFile() {
    }

    public long getCreationDate() {
        return Utils.truncateDate(this.creationDate);
    }

    public long getCreationTime() {
        return this.creationDate;
    }

    public String getFileName() {
        String name = new File(this.fullFileName).getName();
        return name;
    }

    public int getGrade() {
        return this.grade;
    }

    public long getLessonID() {
        return this.lessonID;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void load(String fileName) throws Exception {
        DataInputStream is = new DataInputStream(new FileInputStream(fileName));
        short version = is.readShort();
        if (version == 1) {
            this._$10968(is);
        } else {
            if (version > VERSION) {
                throw new Exception("Incompatible version of student assessment dat file.");
            }
            this._$10969(is);
        }
        is.close();
    }

    private void _$10968(DataInputStream is) throws Exception {
        this.performer = is.readUTF();
        this.instrument = is.readUTF();
        this.creationDate = is.readLong();
        this.scriptTitle = is.readUTF();
        this.scriptID = is.readUTF();
        this.grade = is.readInt();
        this.rhythmAccuracy = is.readDouble();
        this.noteAccuracy = is.readDouble();
        this.pitchAccuracy = is.readDouble();
        this.totalNotes = is.readInt();
        this.pitchTendency = is.readInt();
        this.gradeMethod = is.readInt();
        this.tempoFactor = is.readFloat();
        this.gradeWeightIntonation = is.readInt();
        this.gradeWeightRhythm = is.readInt();
        this.gradeAttackTolerance = is.readInt();
        this.gradeReleaseTolerance = is.readInt();
        this.gradeIntonationTolerance = is.readDouble();
        this.lessonID = this._$6820(this.scriptID);
    }

    private void _$10969(DataInputStream is) throws Exception {
        this._$10968(is);
        this.sn = is.readUTF();
        this.timer = is.readInt();
        this.instrumentID = is.readInt();
        this.bonus = is.readInt();
        this.valid = is.readBoolean();
        this.fill1 = is.readLong();
        this.fill2 = is.readLong();
    }

    public void save(String fileName) throws Exception {
        DataOutputStream os = new DataOutputStream(new FileOutputStream(fileName));
        os.writeShort(VERSION);
        os.writeUTF(this.performer);
        os.writeUTF(this.instrument);
        os.writeLong(this.creationDate);
        os.writeUTF(this.scriptTitle);
        os.writeUTF(this.scriptID);
        os.writeInt(this.grade);
        os.writeDouble(this.rhythmAccuracy);
        os.writeDouble(this.noteAccuracy);
        os.writeDouble(this.pitchAccuracy);
        os.writeInt(this.totalNotes);
        os.writeInt(this.pitchTendency);
        os.writeInt(this.gradeMethod);
        os.writeFloat(this.tempoFactor);
        os.writeInt(this.gradeWeightIntonation);
        os.writeInt(this.gradeWeightRhythm);
        os.writeInt(this.gradeAttackTolerance);
        os.writeInt(this.gradeReleaseTolerance);
        os.writeDouble(this.gradeIntonationTolerance);
        os.writeUTF(this.sn);
        os.writeInt(this.timer);
        os.writeLong(this.instrumentID);
        os.writeInt(this.bonus);
        os.writeBoolean(this.valid);
        os.writeLong(this.fill1);
        os.writeLong(this.fill2);
        os.close();
    }

    public void save() throws Exception {
        this.save(this.fullFileName);
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    private long _$6820(String idStr) {
        long id;
        block3: {
            id = 0L;
            try {
                id = Long.parseLong(idStr, 16);
            }
            catch (Exception e2) {
                String str;
                if (idStr.startsWith("SOE1.")) {
                    str = idStr.substring(5, 9);
                    id = Long.parseLong(str);
                }
                if (!idStr.startsWith("SOE2.")) break block3;
                str = idStr.substring(5, 9);
                id = Long.parseLong(str) + 1000L;
            }
        }
        return id;
    }
}

