/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import pyware.iPasToolkit.interactive.GradingScheme;
import pyware.iPasToolkit.interactive.IPasStudentTable;
import pyware.iPasToolkit.interactive.IPasStudentTableRow;

public class GradeCellRenderer
extends DefaultTableCellRenderer {
    IPasStudentTable studentData = null;

    public GradeCellRenderer(IPasStudentTable studentData) {
        this.setStudentData(studentData);
        this.setHorizontalAlignment(0);
    }

    public GradeCellRenderer() {
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean isSelected, boolean boolean3, int row, int column) {
        Component component = null;
        IPasStudentTableRow data = this.studentData.getRowAt(row);
        component = data.isCompleted() ? super.getTableCellRendererComponent(jTable, object, isSelected, boolean3, row, column) : (!data.isCompleted() && data.isOverdue() ? super.getTableCellRendererComponent(jTable, new Integer(0), isSelected, boolean3, row, column) : super.getTableCellRendererComponent(jTable, null, isSelected, boolean3, row, column));
        if (data.isCompleted() && !data.isCompletedPastDue() && data.isRedoable()) {
            component.setForeground(Color.blue);
        } else if (data.isCompleted() && !data.isCompletedPastDue() && data.isExtended()) {
            component.setForeground(Color.blue);
        } else {
            component.setForeground(Color.black);
        }
        if (isSelected) {
            component.setBackground(jTable.getSelectionBackground());
        } else {
            component.setBackground(jTable.getBackground());
        }
        JLabel lblComponent = (JLabel)component;
        String currentTxt = lblComponent.getText();
        GradingScheme scheme = this.studentData.getGradingScheme();
        int deduction = data.getOverdueDeduction(scheme);
        if (scheme.gradeStyle == GradingScheme.GRADE_STYLE_AVERAGE) {
            if (deduction > 0) {
                lblComponent.setText(currentTxt + "-" + deduction);
            }
        } else if (scheme.gradeStyle == GradingScheme.GRADE_STYLE_MERIT) {
            int points = data.getGrade() < scheme.meritPassScore ? 0 : scheme.meritPassPoints - deduction;
            if (currentTxt.length() > 0) {
                lblComponent.setText(lblComponent.getText() + "|" + points);
            }
        }
        return component;
    }

    public void setStudentData(IPasStudentTable studentData) {
        this.studentData = studentData;
    }
}

