/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import pyware.iPasToolkit.interactive.EvaluationDatFile;
import pyware.iPasToolkit.interactive.IPasStudentTableRow;

class GradeDetailInfo {
    long attachmentID = 0L;
    byte gradeMethod = 0;
    String instrument = null;
    byte subGrade1 = 0;
    byte subGrade2 = 0;
    byte subGrade3 = 0;
    byte subGrade4 = 0;
    byte tempoFactor = 0;
    byte timer = 0;

    public GradeDetailInfo(DataInputStream is) throws Exception {
        this.gradeMethod = is.readByte();
        this.subGrade1 = is.readByte();
        this.subGrade2 = is.readByte();
        this.subGrade3 = is.readByte();
        this.subGrade4 = is.readByte();
        this.tempoFactor = is.readByte();
        this.timer = is.readByte();
        this.attachmentID = is.readLong();
    }

    public GradeDetailInfo() {
    }

    public String getSubGradeStr(int subIndex) {
        if (this.gradeMethod == IPasStudentTableRow.METHOD_SOE) {
            if (subIndex == 1) {
                return "Note Accuracy: " + this.subGrade1 + "%";
            }
            if (subIndex == 2) {
                return "Rhythm Accuracy: " + this.subGrade2 + "%";
            }
        } else {
            if (subIndex == 1) {
                return "Note Accuracy: " + this.subGrade1 + "%";
            }
            if (subIndex == 2) {
                return "Rhythm Accuracy: " + this.subGrade2 + "%";
            }
            if (subIndex == 3) {
                return "Pitch Accuracy: " + this.subGrade3 + "%";
            }
        }
        return "";
    }

    public boolean hasDetail() {
        return this.gradeMethod != 0;
    }

    public void setValues(EvaluationDatFile evaluation) {
        this.gradeMethod = (byte)evaluation.gradeMethod;
        if (this.gradeMethod == IPasStudentTableRow.METHOD_SOE) {
            this.subGrade1 = new Double(evaluation.noteAccuracy * 100.0 + 0.5).byteValue();
            this.subGrade2 = new Double(evaluation.rhythmAccuracy * 100.0 + 0.5).byteValue();
        } else {
            this.subGrade1 = new Double(evaluation.noteAccuracy * 100.0 + 0.5).byteValue();
            this.subGrade2 = new Double(evaluation.rhythmAccuracy * 100.0 + 0.5).byteValue();
            this.subGrade3 = new Double(evaluation.pitchAccuracy * 100.0 + 0.5).byteValue();
        }
        this.tempoFactor = new Float((double)(evaluation.tempoFactor * 100.0f) + 0.5).byteValue();
        this.timer = (byte)evaluation.timer;
        this.instrument = evaluation.instrument;
        this.attachmentID = evaluation.creationDate;
    }

    public void setValues(GradeDetailInfo item) {
        this.gradeMethod = item.gradeMethod;
        this.subGrade1 = item.subGrade1;
        this.subGrade2 = item.subGrade2;
        this.subGrade3 = item.subGrade3;
        this.subGrade4 = item.subGrade4;
        this.tempoFactor = item.tempoFactor;
        this.timer = item.timer;
        this.attachmentID = item.attachmentID;
    }

    public void write(DataOutputStream os) throws Exception {
        os.writeByte(this.gradeMethod);
        os.writeByte(this.subGrade1);
        os.writeByte(this.subGrade2);
        os.writeByte(this.subGrade3);
        os.writeByte(this.subGrade4);
        os.writeByte(this.tempoFactor);
        os.writeByte(this.timer);
        os.writeLong(this.attachmentID);
    }
}

