/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.sql.Timestamp;
import pyware.toolkit.IniFile;
import pyware.toolkit.KeyCodeFactory;

public class IPASOnlineAccountPrefs {
    long downloadTaskID = System.currentTimeMillis();
    private IniFile _$7831;

    public IPASOnlineAccountPrefs(String fileName) {
        this._$7831 = new IniFile(fileName);
    }

    public String getAccountSN() {
        return this._$7831.getLine("Account", "SN", "");
    }

    public String getOperatorMessage() {
        return this._$7831.getLine("Account", "OperatorMessage", "");
    }

    public int getUnusedFileExpiration() {
        return this._$7831.getIntLine("Limits", "UnusedFileExpiration", 0);
    }

    public String getValidCIDs() {
        return this._$7831.getLine("Install", "ValidCIDs", "").toUpperCase();
    }

    public boolean isAccountExpired() {
        Timestamp created = this._$7831.getTimeStampLine("Account", "Created", new Timestamp(0L));
        int days = this._$7831.getIntLine("Limits", "AccountExpire", 0);
        if (days == 0) {
            return false;
        }
        return created.getTime() + (long)days * KeyCodeFactory.MSEC_PER_DAY < System.currentTimeMillis();
    }

    public boolean isAccountStatusExpired() {
        return this._$7831.getLine("Account", "Status", "").toLowerCase().startsWith("expired");
    }

    public boolean isAccountStatusGood() {
        return this._$7831.getLine("Account", "Status", "").toLowerCase().startsWith("good");
    }

    public boolean isCIDValid(String cid) {
        String validCIDs = this.getValidCIDs();
        if (cid.equalsIgnoreCase("000")) {
            return true;
        }
        return validCIDs.indexOf(cid) != -1;
    }

    public boolean isSNValid(String sn) {
        return this.getAccountSN().equalsIgnoreCase(sn);
    }
}

