/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import com.borland.jbcl.layout.VerticalFlowLayout;
import ipworks.Ftp;
import ipworks.FtpConnectionStatusEvent;
import ipworks.FtpDirListEvent;
import ipworks.FtpEndTransferEvent;
import ipworks.FtpErrorEvent;
import ipworks.FtpEventListener;
import ipworks.FtpPITrailEvent;
import ipworks.FtpStartTransferEvent;
import ipworks.FtpTransferEvent;
import ipworks.IPWorksException;
import ipworkszip.IPWorksZipException;
import ipworkszip.Zip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import jbc.beans.JbcProgressBar;
import pyware.iPasToolkit.interactive.IPASOnlineAccountPrefs;
import pyware.iPasToolkit.interactive.IPASOnlineSystemPrefs;
import pyware.iPasToolkit.interactive.IPasLibrarianEvent;
import pyware.iPasToolkit.interactive.IPasLibrarianException;
import pyware.iPasToolkit.interactive.IPasLibrarianListener;
import pyware.iPasToolkit.interactive.IPasLibrarianTask;
import pyware.iPasToolkit.interactive.IPasLibrarian_btnStart_actionAdapter;
import pyware.iPasToolkit.interactive.LessonList;
import pyware.iPasToolkit.interactive.OnlineFileInfo;
import pyware.iPasToolkit.interactive.OnlineFileList;
import pyware.iPasToolkit.interactive.StudentRoster;
import pyware.iPasToolkit.interactive.StudentRosterItem;
import pyware.toolkit.Decoder;
import pyware.toolkit.FileUtils;
import pyware.toolkit.IniFile;
import pyware.toolkit.Utils;

public class IPasLibrarian
extends JDialog
implements FtpEventListener {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton btnStart = new JButton();
    JLabel taskItemProgressMsg = new JLabel();
    JbcProgressBar taskItemProgressBar = new JbcProgressBar();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    ActionListener cancelListener = null;
    JLabel taskListProgressMsg = new JLabel();
    JbcProgressBar taskListProgressBar = new JbcProgressBar();
    Border border1;
    public static int TRACE_NONE = 0;
    public static int TRACE_VERBOSE = 1;
    public static int TRACE_LIGHT = 2;
    private boolean _$3970 = true;
    private Zip _$3971 = new Zip();
    private Decoder _$3972;
    private Vector _$1509 = new Vector();
    private Ftp _$3973 = new Ftp();
    private LessonList _$3974 = new LessonList();
    private OnlineFileList _$3975;
    private StudentRoster _$3976 = new StudentRoster();
    private Frame _$3977;
    private Vector _$3978 = new Vector();
    private IPasLibrarianTask _$3979 = null;
    private long _$3980 = 0L;
    private boolean _$3981 = true;
    private OnlineFileInfo _$3982 = null;
    private boolean _$3983 = false;
    private String _$3984 = null;
    private String _$3985 = null;
    private String _$3986 = null;
    private String _$3987 = null;
    private boolean _$3988 = false;
    private boolean _$3989 = false;
    private String _$3990 = null;
    private String _$3991 = null;
    private String _$3992 = "";
    private String _$3993 = null;
    private IPASOnlineSystemPrefs _$3994 = null;
    private IPASOnlineAccountPrefs _$3995 = null;
    private String _$3996 = null;
    private String _$3997 = null;
    private int _$3998 = 0;
    private boolean _$3999 = true;
    private int _$4000 = 0;
    private int _$4001 = 0;
    private int _$4002 = 0;
    private int _$4003 = 0;
    private String _$4004 = "";
    public boolean pausing = false;
    private boolean _$4006 = false;
    private String _$4007;
    private String _$4008;
    private String _$4009;
    private int _$4010;
    private int _$4011;
    private Timer _$4012 = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            IPasLibrarian.this._$4013();
        }
    });

    public IPasLibrarian(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this._$4016();
            this.pack();
            Utils.centerDialog(frame, this);
            this.enableEvents(64L);
            this.getRootPane().setDefaultButton(this.btnStart);
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public IPasLibrarian() {
        this((Frame)null, "", false);
    }

    public IPasLibrarian(Frame frame) {
        this(frame, "iPAS Online Librarian", true);
        this._$3977 = frame;
    }

    public IPasLibrarian(Frame frame, IniFile ftpSettings, String ftpSection, IniFile appSettings, Decoder decoder) throws IPasLibrarianException {
        this(frame);
        this.initialize(ftpSettings, ftpSection, appSettings, decoder);
    }

    public void initialize(IniFile ftpSettings, String ftpSection, IniFile appSettings, Decoder decoder) throws IPasLibrarianException {
        this._$3972 = decoder;
        this._$4027(ftpSettings, ftpSection, appSettings);
        this._$3975 = new OnlineFileList(this._$3992);
        this.cleanup();
        File file = new File(this._$3992 + "temp");
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private void _$4016() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(0, 10, 0, 10);
        this.panel1.setLayout(this.borderLayout1);
        this.btnStart.setPreferredSize(new Dimension(80, 23));
        this.btnStart.setText("Start");
        this.btnStart.addActionListener(new IPasLibrarian_btnStart_actionAdapter(this));
        this.taskItemProgressMsg.setHorizontalAlignment(0);
        this.taskItemProgressMsg.setText("...");
        this.jPanel1.setLayout(this.verticalFlowLayout1);
        this.panel1.setPreferredSize(new Dimension(400, 150));
        this.taskListProgressMsg.setHorizontalAlignment(0);
        this.taskListProgressMsg.setText("...");
        this.verticalFlowLayout1.setAlignment(1);
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.add((Component)this.taskListProgressMsg, null);
        this.jPanel1.add((Component)this.taskListProgressBar, null);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.taskItemProgressMsg, null);
        this.jPanel1.add((Component)this.taskItemProgressBar, null);
        this.panel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.btnStart, null);
    }

    public void cleanup() {
        File[] list = new File(this._$3992 + "temp").listFiles();
        if (list != null) {
            for (int i2 = 0; i2 < list.length; ++i2) {
                list[i2].delete();
            }
        }
        new File(this._$3992 + "temp").delete();
    }

    protected void processWindowEvent(WindowEvent e2) {
        if (e2.getID() == 201) {
            if (this.isConnected()) {
                this._$4044();
            } else {
                super.processWindowEvent(e2);
            }
        }
    }

    public void setOnlineAccountDir(String onlineAccountDir) {
        this._$4046();
        this._$3988 = false;
        this._$3990 = onlineAccountDir;
    }

    public void setServerID(String sid) {
        this._$3985 = sid;
    }

    private void _$4027(IniFile ftpSettings, String ftpSection, IniFile appSettings) throws IPasLibrarianException {
        this._$3984 = ftpSettings.getLine(ftpSection, "H", null);
        this._$3986 = ftpSettings.getLine(ftpSection, "U", "");
        this._$3987 = ftpSettings.getLine(ftpSection, "P", "");
        this._$3991 = this._$3972.decode(ftpSettings.getLine(ftpSection, "R", null));
        this._$3985 = appSettings.getLine("FTP", "SID", "");
        this._$3993 = appSettings.getLine("FTP", "OfflineMirror", null);
        this._$3992 = appSettings.getLine("FTP", "LocalPath", "temp");
        this._$3996 = appSettings.getLine("Licensing", "SN", null);
        this._$3997 = appSettings.getLine("Licensing", "ComputerID", null);
        if (this._$3984 == null) {
            throw new IPasLibrarianException("No remote host connection information was found.", IPasLibrarianException.FTP_SETUP_ERROR);
        }
        this.setLessonListPaths(appSettings.getStringList("FTP", "iPASBridge"));
        this._$4006 = appSettings.getBoolLine("Firewall", "Enable", false);
        if (this._$4006) {
            this._$4007 = appSettings.getEncodedLine("Firewall", "Host", "");
            this._$4008 = appSettings.getEncodedLine("Firewall", "User", "");
            this._$4009 = appSettings.getEncodedLine("Firewall", "Password", "");
            this._$4010 = new Integer(appSettings.getEncodedLine("Firewall", "Port", "0"));
            String type = appSettings.getEncodedLine("Firewall", "Type", "Tunnel");
            if (type.equalsIgnoreCase("tunnel")) {
                this._$4011 = 1;
            }
            if (type.equalsIgnoreCase("socks4")) {
                this._$4011 = 2;
            }
            if (type.equalsIgnoreCase("socks5")) {
                this._$4011 = 3;
            }
        }
    }

    public void setLessonListPaths(String[] pathsToLessons) {
        this._$3974.initialize(pathsToLessons, this._$3992);
    }

    private void _$4058(String msg) {
        if (msg == null) {
            this._$4002 = 1;
            this._$4003 = 1;
            this._$4004 = " ";
        } else {
            this._$4004 = msg;
        }
    }

    private void _$4059(long value, long max) {
        this._$4002 = new Long(value).intValue();
        this._$4003 = new Long(max).intValue();
    }

    private void _$4060(int value, int max) {
        this._$4002 = new Long(value).intValue();
        if (max > 0) {
            this._$4003 = new Long(max).intValue();
        }
    }

    private void _$4061(int max) {
        this._$4000 = 0;
        this._$4001 = max;
        this._$4002 = 0;
        this._$4003 = 0;
    }

    private void _$4062() {
        ++this._$4000;
        this._$4002 = 0;
        this._$4003 = 0;
    }

    private void _$4013() {
        this.taskListProgressBar.setMaximum(this._$4001);
        this.taskListProgressBar.setValue(this._$4000);
        this.taskItemProgressBar.setMaximum(this._$4003);
        this.taskItemProgressBar.setValue(this._$4002);
        this.taskItemProgressMsg.setText(this._$4004);
    }

    private void _$4064() {
        this.btnStart.setEnabled(true);
        this.btnStart.setVisible(!this.isWorkingOffline());
        this.taskListProgressBar.setVisible(false);
        this.taskItemProgressBar.setVisible(false);
        if (this.isWorkingOffline()) {
            this.taskListProgressMsg.setText("Preparing to transfer information.");
            this._$4004 = "";
        } else {
            this.taskListProgressMsg.setText("If necessary, connected to the internet now.");
            this._$4004 = "Click [Start] when ready.";
        }
        this.taskItemProgressMsg.setText(this._$4004);
        this.btnStart.setText("Start");
        this._$4061(this._$3978.size());
    }

    private void _$4068(boolean success) {
        this._$4012.stop();
        if (success) {
            this.btnStart.setText("Finish");
        } else {
            this.btnStart.setText("Exit");
        }
        this.taskItemProgressMsg.setText("");
        this.taskItemProgressBar.setValue(this.taskItemProgressBar.getMaximum());
        this.taskListProgressBar.setValue(this.taskListProgressBar.getMaximum());
    }

    private void _$4070(int level, String msg) {
        if (this._$3998 == 0) {
            return;
        }
        if (this._$3998 == 1 && level >= 1) {
            System.out.println(msg);
        }
        if (this._$3998 == 2 && level >= 2) {
            System.out.println(msg);
        }
    }

    private void _$4046() {
        this._$3975.initialize();
        this._$3988 = false;
    }

    private IPasLibrarianTask _$4074(int i2) {
        return (IPasLibrarianTask)this._$3978.elementAt(i2);
    }

    private void _$4075() throws IPasLibrarianException {
        if (this.isWorkingOffline()) {
            return;
        }
        try {
            this._$4058("Connecting to iPAS Online Accounts");
            this._$3973.addFtpEventListener(this);
            this._$3973.setRemoteHost(this._$3972.decode(this._$3984).toLowerCase().replaceAll("<sid>", this._$3985));
            this._$3973.setUser(this._$3972.decode(this._$3986));
            this._$3973.setPassword(this._$3972.decode(this._$3987));
            if (this._$4006) {
                this._$3973.setFirewallHost(this._$4007);
                this._$3973.setFirewallUser(this._$4008);
                this._$3973.setFirewallPassword(this._$4009);
                this._$3973.setFirewallType(this._$4011);
                if (this._$4010 != 0) {
                    this._$3973.setFirewallPort(this._$4010);
                }
            }
            this._$3973.setTransferMode(2);
            this._$3973.setPassive(true);
            this._$4060(1, 2);
            this._$3973.logon();
        }
        catch (Exception ex2) {
            throw new IPasLibrarianException("Unable to connect to the internet.", IPasLibrarianException.FTP_LOGON_ERROR);
        }
    }

    private void _$4090(boolean success, IPasLibrarianException ex2) {
        this._$4070(TRACE_VERBOSE, "... Logging off");
        try {
            this._$4058("Disconnecting from iPAS Online.");
            if (!this.isWorkingOffline()) {
                this._$3973.logoff();
            }
            if (this._$3981) {
                this.hide();
            }
            if (success) {
                this._$4068(true);
                this._$4093();
            } else {
                this._$4068(false);
                this._$4094(this._$3979, ex2);
            }
        }
        catch (IPWorksException e2) {
            this.hide();
        }
    }

    private void _$4095() {
        this._$3974.reload();
        this._$3975.rescanForLocal();
        this._$4070(TRACE_VERBOSE, "... Starting log off timer");
        Timer timerToDisconnect = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPasLibrarian.this._$4090(true, null);
            }
        });
        timerToDisconnect.setRepeats(false);
        timerToDisconnect.start();
    }

    private String _$4099(String fullSourceName, String remoteFile) throws IPasLibrarianException {
        String fileName = new File(fullSourceName).getName();
        String fullZippedLocalPath = this._$3992 + "temp/" + fileName + ".zip";
        try {
            this._$3971.setArchiveFile(fullZippedLocalPath);
            this._$3971.setFileCount(1);
            this._$3971.setFileDecompressedName(0, fullSourceName);
            this._$3971.setFileCompressedName(0, remoteFile);
            this._$3971.compress();
        }
        catch (IPWorksZipException ex2) {
            throw new IPasLibrarianException("Unable to compress file. " + ex2.getMessage(), IPasLibrarianException.FILE_ZIP_ERROR);
        }
        return fullZippedLocalPath;
    }

    private void _$4109(String sourceName, String fullDestPath) throws IPasLibrarianException {
        String unzippedSourcePath = this._$3992 + "temp/" + sourceName;
        String zippedSourcePath = FileUtils.appendSuffix(unzippedSourcePath, ".zip");
        try {
            this._$3971.setArchiveFile(zippedSourcePath);
            this._$3971.setExtractToPath(this._$3992 + "temp");
            this._$3971.extractAll();
        }
        catch (IPWorksZipException ex2) {
            throw new IPasLibrarianException("Unable to unzip file. " + ex2.getMessage(), IPasLibrarianException.FILE_UNZIP_ERROR);
        }
        FileUtils.copyFile(unzippedSourcePath, fullDestPath);
    }

    private void _$4117(String remotePath) throws IPWorksException {
        if (remotePath == null) {
            remotePath = this._$3991 + this._$3990;
        } else if (remotePath.equalsIgnoreCase("<root>")) {
            remotePath = this._$3991;
        }
        if (this.isWorkingOffline()) {
            return;
        }
        this._$4070(TRACE_VERBOSE, "... Set remote path to " + remotePath);
        this._$3973.setRemotePath(remotePath.toLowerCase());
    }

    public void connectionStatus(FtpConnectionStatusEvent e2) {
    }

    public void dirList(FtpDirListEvent e2) {
        String fileName = FileUtils.removeSuffix(e2.fileName, ".zip");
        this._$4070(TRACE_VERBOSE, "... Directory list: " + fileName);
        this._$3975.updateOnlineFileInfo(fileName, e2.fileTime, e2.fileSize);
    }

    public void startTransfer(FtpStartTransferEvent e2) {
    }

    public void transfer(FtpTransferEvent e2) {
        if (this._$3979.isType(IPasLibrarianTask.UPLOAD)) {
            this._$4059(e2.bytesTransferred, new File(this._$3979.localPath).length());
        }
        if (this._$3979.isType(IPasLibrarianTask.DOWNLOAD) && this._$3982 != null) {
            this._$4059(e2.bytesTransferred, this._$3982.getOnlineFileSize());
        }
    }

    public void endTransfer(FtpEndTransferEvent e2) {
        if (this._$3979.isType(IPasLibrarianTask.OPEN_ACCOUNT)) {
            this._$3988 = true;
            this._$4070(TRACE_VERBOSE, "... end of Directory List");
        }
        if (this._$3979.taskType == IPasLibrarianTask.UPLOAD) {
            if (!this._$3979.leaveOnSource) {
                new File(this._$3979.localPath).delete();
            }
            this._$4060(1, 1);
        }
        if (this._$3979.transferDirection == IPasLibrarianTask.DOWNLOAD_DIRECTION) {
            this._$4060(1, 1);
            this._$3975.markFileDownloaded(this._$3979.remoteFile);
        }
    }

    public void error(FtpErrorEvent e2) {
        this._$4070(TRACE_LIGHT, "FTP ERROR: " + e2.description);
    }

    public void PITrail(FtpPITrailEvent e2) {
        this._$4070(TRACE_VERBOSE, "### " + e2.message);
        if (this._$3979.checkCompletion(e2.message)) {
            this._$4141();
        }
    }

    private void _$4142(IPasLibrarianTask task) throws IPasLibrarianException {
        if (this.isWorkingOffline()) {
            throw new IPasLibrarianException("Unable to access headquarters while working offline.", IPasLibrarianException.FTP_LOGON_ERROR);
        }
        try {
            this._$4060(1, 3);
            this._$4117(task.remotePath);
            this._$4060(2, 3);
            this._$3973.setRemoteFile(null);
            if (task.mustExist) {
                this._$3973.listDirectoryLong();
            }
        }
        catch (IPWorksException ex2) {
            throw new IPasLibrarianException("Unable to find headquarters.", IPasLibrarianException.ACCOUNT_NOT_FOUND_ERROR);
        }
    }

    private void _$4148(IPasLibrarianTask task) throws IPasLibrarianException {
        if (this.isWorkingOffline()) {
            this._$4046();
            File[] files = new File(this._$3993).listFiles();
            for (int i2 = 0; i2 < files.length; ++i2) {
                this._$3975.updateOnlineFileInfo(files[i2].getName(), new Long(files[i2].lastModified()).toString(), files[i2].length());
            }
            this._$3988 = true;
            this.nextTask();
            return;
        }
        try {
            this._$4060(1, 3);
            this._$4117(task.remotePath);
            this._$4060(2, 3);
            this._$3973.setRemoteFile(null);
            if (task.mustExist) {
                this._$3973.listDirectoryLong();
            }
        }
        catch (IPWorksException ex2) {
            throw new IPasLibrarianException("Unable to find the school account.", IPasLibrarianException.ACCOUNT_NOT_FOUND_ERROR);
        }
    }

    private void _$4151(IPasLibrarianTask task) throws IPasLibrarianException {
        OnlineFileInfo info;
        if (!task.canOverwrite && (info = this._$3975.find(task.remoteFile)) != null && info.isOnline()) {
            this.nextTask();
            return;
        }
        if (this.isWorkingOffline()) {
            if (!FileUtils.copyFile(task.localPath, this._$3993 + task.remoteFile)) {
                throw new IPasLibrarianException("Unable to copy file [" + task.remoteFile + "] to " + this._$3993 + '.', IPasLibrarianException.FILE_UPLOAD_ERROR);
            }
            if (!task.leaveOnSource) {
                new File(task.localPath).delete();
            }
            this.nextTask();
            return;
        }
        try {
            String tempRemoteFileName = FileUtils.appendSuffix(task.remoteFile, ".tmp");
            String zippedRemoteFileName = FileUtils.appendSuffix(task.remoteFile, ".zip");
            String fullZippedLocalPath = this._$4099(task.localPath, task.remoteFile);
            this._$3973.setLocalFile(fullZippedLocalPath);
            this._$3973.setRemoteFile(tempRemoteFileName.toLowerCase());
            this._$3973.upload();
            this._$3973.renameFile(zippedRemoteFileName.toLowerCase());
        }
        catch (Exception ex2) {
            throw new IPasLibrarianException("Unable to upload file [" + task.remoteFile + "].", IPasLibrarianException.FILE_UPLOAD_ERROR);
        }
    }

    private void _$4161(IPasLibrarianTask task) throws IPasLibrarianException {
        this._$3982 = this._$3975.find(task.remoteFile);
        if (this._$3982 != null) {
            if (this._$3982.isDownloadCurrent()) {
                this._$4070(TRACE_VERBOSE, "... Local already current: " + task.localPath);
                task.taskResult = IPasLibrarianTask.ONLINE_NOT_NEWER;
                this.nextTask();
                return;
            }
            if (!this._$3982.isOnline() && !task.mustExist) {
                this._$4070(TRACE_VERBOSE, "... Was not found but continued. (mustExist=false) File: " + task.localPath);
                task.taskResult = IPasLibrarianTask.ONLINE_NOT_NEWER;
                this.nextTask();
                return;
            }
        } else if (!task.mustExist) {
            this._$4070(TRACE_VERBOSE, "... Was not found but continued. (mustExist=false) File: " + task.localPath);
            this.nextTask();
            return;
        }
        task.taskResult = IPasLibrarianTask.ONLINE_WAS_NEWER;
        if (this.isWorkingOffline()) {
            if (!FileUtils.copyFile(this._$3993 + task.remoteFile, task.localPath)) {
                throw new IPasLibrarianException("Unable to copy file [" + task.remoteFile + "] from " + this._$3993 + '.', IPasLibrarianException.FILE_DOWNLOAD_ERROR);
            }
            this.nextTask();
            return;
        }
        try {
            String zippedRemoteFileName = FileUtils.appendSuffix(task.remoteFile, ".zip");
            String zippedLocalFileName = FileUtils.appendSuffix(new File(task.localPath).getName(), ".zip");
            String fullZippedLocalPath = this._$3992 + "temp/" + zippedLocalFileName;
            this._$4060(1, 3);
            this._$3973.setLocalFile(fullZippedLocalPath);
            this._$3973.setRemoteFile(zippedRemoteFileName.toLowerCase());
            this._$4060(2, 3);
            this._$3973.download();
        }
        catch (IPWorksException ex2) {
            if (ex2.getMessage().indexOf("550") == -1) {
                throw new IPasLibrarianException("Unable to download file [" + task.remoteFile + "].", IPasLibrarianException.FILE_DOWNLOAD_ERROR);
            }
            throw new IPasLibrarianException("Unable to download file [" + task.remoteFile + "].", IPasLibrarianException.FILE_NOT_FOUND);
        }
    }

    private void _$4171(IPasLibrarianTask task) throws IPasLibrarianException {
        long studentDBID = this.getStudentDBID(task.altPath);
        task.localPath = this._$3992 + studentDBID + ".asn";
        task.remoteFile = studentDBID + ".asn";
        this._$4161(task);
    }

    private void _$4175(IPasLibrarianTask task) throws IPasLibrarianException {
        long studentDBID = this.getStudentDBID(task.altPath);
        task.localPath = this._$3992 + studentDBID + ".anc";
        task.remoteFile = studentDBID + ".anc";
        task.mustExist = false;
        this._$4161(task);
    }

    private void _$4176() {
        OnlineFileInfo[] list = this._$3975.findOnlyOnline(OnlineFileInfo.STUDENT_ASSESSMENT_LOG);
        if (list != null) {
            for (int i2 = 0; i2 < list.length; ++i2) {
                if (!this.isWorkingOffline()) {
                    this._$4179(IPasLibrarianTask.createDeleteFromServer(list[i2].getFileName(), true, "Cleaning student log from online account. (ID:" + list[i2].getStudentID() + ')'));
                }
                this._$4179(IPasLibrarianTask.createDownloadTask(list[i2].getFileName(), this._$3992, false, "Downloading student log (ID:" + list[i2].getStudentID() + ')'));
                this.taskListProgressBar.setMaximum(this.taskListProgressBar.getMaximum() + 2);
            }
        }
        this.nextTask();
    }

    private void _$4184(IPasLibrarianTask task) throws IPasLibrarianException {
        String oldPath = task.localPath;
        String newName = task.altPath;
        try {
            File oldFile = new File(oldPath);
            if (!oldFile.exists()) {
                throw new Exception();
            }
            File newFile = new File(newName);
            if (newFile.exists()) {
                newFile.delete();
            }
            if (!oldFile.renameTo(newFile)) {
                throw new Exception();
            }
            this.nextTask();
        }
        catch (Exception ex2) {
            throw new IPasLibrarianException("File [" + oldPath + "] was not renamed to [" + newName + "]", IPasLibrarianException.LOCAL_FILE_RENAME_ERROR);
        }
    }

    private void _$4190(IPasLibrarianTask task) throws IPasLibrarianException {
        String sourcePath = task.localPath;
        String destPath = task.altPath;
        try {
            FileUtils.copyFile(sourcePath, destPath);
            this.nextTask();
        }
        catch (Exception ex2) {
            throw new IPasLibrarianException("File [" + sourcePath + "] was not copied to [" + destPath + "]", IPasLibrarianException.LOCAL_FILE_RENAME_ERROR);
        }
    }

    private void _$4193(IPasLibrarianTask task) throws IPasLibrarianException {
        try {
            String zippedFileName = FileUtils.appendSuffix(task.remoteFile, ".zip");
            if (this.isWorkingOffline()) {
                new File(this._$3993 + task.remoteFile).delete();
            } else {
                this._$3973.deleteFile(zippedFileName.toLowerCase());
            }
            this._$4141();
        }
        catch (IPWorksException ex2) {
            if (!task.mustExist) {
                this._$4141();
                return;
            }
            throw new IPasLibrarianException("Unable to delete file [" + task.remoteFile + "] from online account.", IPasLibrarianException.DELETE_REMOTE_FILE_ERROR);
        }
    }

    private void _$4197(IPasLibrarianTask task) throws IPasLibrarianException {
        if (this._$3995 == null) {
            throw new IPasLibrarianException("Unable to delete expired attachments.  Account preferences were not downloaded first.", IPasLibrarianException.DELETE_EXPIRED_ATTACHMENTS_ERROR);
        }
        OnlineFileInfo[] expiredList = this._$3975.findOnlineExpired(this._$3995.getUnusedFileExpiration());
        for (int i2 = 0; i2 < expiredList.length; ++i2) {
            String fileName = expiredList[i2].getFileName();
            this.addTask(IPasLibrarianTask.createDeleteFromServer(fileName, true, "Deleting expired recordings and graphs from account. File:" + fileName));
            this.taskListProgressBar.setMaximum(this.taskListProgressBar.getMaximum() + 1);
        }
        this._$4141();
    }

    private void _$4203(IPasLibrarianTask task) throws IPasLibrarianException {
        OnlineFileInfo fileInfo;
        boolean exists;
        boolean checkOnline = task.localPath == null;
        String fileName = task.remoteFile;
        if (!checkOnline) {
            fileName = new File(task.localPath).getName();
        }
        if (exists = (fileInfo = this._$3975.find(fileName)) == null ? false : (checkOnline ? fileInfo.isOnline() : fileInfo.isLocal())) {
            task.taskResult = 1;
        }
        if (!exists && task.mustExist) {
            throw new IPasLibrarianException(task.altPath, IPasLibrarianException.FILE_NOT_FOUND);
        }
        this.nextTask();
    }

    private void _$4206() {
        while (this.pausing) {
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.nextTask();
    }

    private void _$4207(IPasLibrarianTask task) throws IPasLibrarianException {
        if (new File(task.localPath).length() == 0L) {
            return;
        }
        try {
            new File("Lessons/Custom Lessons").mkdirs();
            Zip zip = new Zip();
            zip.setArchiveFile(task.localPath);
            zip.setExtractToPath(this._$3992 + "temp/");
            zip.extractAll();
            File[] files = new File(this._$3992 + "temp/").listFiles();
            zip.setExtractToPath("Lessons/Custom Lessons");
            for (int i2 = 0; i2 < files.length; ++i2) {
                if (!files[i2].getName().endsWith(".lnz")) continue;
                zip.setArchiveFile(files[i2].getPath());
                zip.extractAll();
            }
        }
        catch (IPWorksZipException ex2) {
            throw new IPasLibrarianException("Unable to unzip custom lesson package.", IPasLibrarianException.FILE_UNZIP_ERROR);
        }
    }

    private void _$4208(IPasLibrarianTask task) throws IPasLibrarianException {
        if (this._$3983) {
            this.nextTask();
            return;
        }
        this._$4070(TRACE_LIGHT, ">>> Starting Task: " + task.message);
        this._$3979 = task;
        if (this._$3979.taskType == IPasLibrarianTask.PAUSE) {
            this.pausing = true;
        }
        this._$4058(this._$3979.message);
        this._$4210(this._$3979);
        if (this._$3979.taskType == IPasLibrarianTask.OPEN_ACCOUNT) {
            this._$4148(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.OPEN_HEADQUARTERS) {
            this._$4142(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.UPLOAD) {
            this._$4151(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.DOWNLOAD | this._$3979.taskType == IPasLibrarianTask.DOWNLOAD_STUDENT_ROSTER | this._$3979.taskType == IPasLibrarianTask.DOWNLOAD_SYSTEM_PREFS | this._$3979.taskType == IPasLibrarianTask.DOWNLOAD_CUSTOM_LESSONS | this._$3979.taskType == IPasLibrarianTask.DOWNLOAD_ACCOUNT_PREFS) {
            this._$4161(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.DOWNLOAD_STUDENT_ASSIGNMENT) {
            this._$4171(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.DOWNLOAD_STUDENT_ANNOUNCEMENTS) {
            this._$4175(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.DOWNLOAD_ALL_LOGS) {
            this._$4176();
        } else if (this._$3979.taskType == IPasLibrarianTask.RENAME_LOCAL) {
            this._$4184(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.COPY_LOCAL) {
            this._$4190(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.DELETE_FROM_SERVER) {
            this._$4193(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.DELETE_EXPIRED_ATTACHMENTS_FROM_SERVER) {
            this._$4197(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.CHECK_FILE_EXIST) {
            this._$4203(this._$3979);
        } else if (this._$3979.taskType == IPasLibrarianTask.PAUSE) {
            this._$4206();
        }
    }

    private void _$4224() {
        this.btnStart.setText("Cancel");
        this.taskListProgressMsg.setText("Progress");
        this.taskListProgressBar.setVisible(true);
        this.taskItemProgressBar.setVisible(true);
        this._$4225();
        this._$3983 = false;
        this._$3979 = null;
        this._$4012.setRepeats(true);
        this._$4012.start();
        this.nextTask();
    }

    private void _$4044() {
        this.btnStart.setEnabled(false);
        this._$3983 = true;
        this._$4058("Preparing to disconnect....");
    }

    private void _$4226(IPasLibrarianTask task) throws IPasLibrarianException {
        if (task == null) {
            return;
        }
        if (this._$3983) {
            return;
        }
        if (task.transferDirection == IPasLibrarianTask.DOWNLOAD_DIRECTION) {
            if (task.taskResult == IPasLibrarianTask.ONLINE_WAS_NEWER && !this.isWorkingOffline()) {
                try {
                    String unzippedLocalFileName = new File(task.localPath).getName();
                    this._$4109(unzippedLocalFileName, task.localPath);
                }
                catch (Exception ex1) {
                    if (!task.mustExist) {
                        this._$4229(task);
                        return;
                    }
                    throw new IPasLibrarianException("Unable to unzip file. (" + task.localPath + ')', IPasLibrarianException.FILE_UNZIP_ERROR);
                }
            }
        }
        if (task.taskType == IPasLibrarianTask.DOWNLOAD_STUDENT_ROSTER) {
            try {
                this._$4070(TRACE_VERBOSE, "... Reading Student Roster");
                this._$3976.load(task.localPath);
            }
            catch (Exception ex2) {
                throw new IPasLibrarianException("Unable to read roster file.", IPasLibrarianException.STUDENT_ROSTER_LOAD_ERROR);
            }
        }
        if (task.taskType == IPasLibrarianTask.DOWNLOAD_STUDENT_ASSIGNMENT) {
            this._$4070(TRACE_VERBOSE, "... Creating Top 10 Lists");
            this._$3974.buildTop10(this._$3976, task.localPath);
        }
        if (task.taskType == IPasLibrarianTask.DOWNLOAD_CUSTOM_LESSONS) {
            this._$4070(TRACE_VERBOSE, "... Extracting custom lessons from package");
            this._$4207(task);
        }
        if (task.taskType == IPasLibrarianTask.DOWNLOAD_SYSTEM_PREFS) {
            this._$3994 = new IPASOnlineSystemPrefs(task.localPath);
            if (this._$3996 != null && this._$3994.isSerialNumberBlocked(this._$3996)) {
                throw new IPasLibrarianException("Access to this account has been denied. (SN:" + this._$3996 + ")\n" + this._$3994.getBlockedMessage(this._$3996), IPasLibrarianException.ACCOUNT_ACCESS_DENIED);
            }
        }
        if (task.taskType == IPasLibrarianTask.DOWNLOAD_ACCOUNT_PREFS) {
            this._$3995 = new IPASOnlineAccountPrefs(task.localPath);
            if (this._$3995.isAccountStatusExpired() | this._$3995.isAccountExpired()) {
                throw new IPasLibrarianException("This online account has expired.", IPasLibrarianException.ACCOUNT_EXPIRED);
            }
            if (!this._$3995.isAccountStatusGood()) {
                throw new IPasLibrarianException("Access to this account has been denied.\n" + this._$3995.getOperatorMessage(), IPasLibrarianException.ACCOUNT_ACCESS_DENIED);
            }
            if (this._$3970 && !this._$3995.isSNValid(this._$3996)) {
                throw new IPasLibrarianException("This serial sumber [" + this._$3996 + "] is not registered with this account.", IPasLibrarianException.ACCOUNT_ACCESS_DENIED);
            }
            if (this._$3970 && !this._$3995.isCIDValid(this._$3997)) {
                throw new IPasLibrarianException("This Computer ID [" + this._$3997 + "] is not registered with this account.", IPasLibrarianException.ACCOUNT_ACCESS_DENIED_CID);
            }
        }
        if (task.taskType == IPasLibrarianTask.DOWNLOAD_STUDENT_ANNOUNCEMENTS && this._$3982 != null && this._$3982.isLocal() && !this._$3982.isOnline()) {
            new File(task.localPath).delete();
        }
        this._$4229(task);
    }

    private void _$4141() {
        Timer timerToStartNextTask = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPasLibrarian.this.nextTask();
            }
        });
        timerToStartNextTask.setRepeats(false);
        timerToStartNextTask.start();
    }

    void nextTask() {
        try {
            this._$4226(this._$3979);
            if (this._$3978.isEmpty()) {
                if (this._$3983) {
                    this._$4090(false, new IPasLibrarianException("Cancelled by user...", 0L));
                } else {
                    this._$4095();
                }
            } else {
                if (!this.isConnected()) {
                    this._$4075();
                }
                this._$4062();
                IPasLibrarianTask task = this._$4074(0);
                this._$3978.remove(0);
                this._$4208(task);
            }
        }
        catch (IPasLibrarianException ex2) {
            this._$4090(false, ex2);
        }
    }

    public long getTaskListID() {
        return this._$3980;
    }

    public long addTask(IPasLibrarianTask task) {
        this._$3978.add(task);
        ++this._$4001;
        return task.id;
    }

    private long _$4179(IPasLibrarianTask task) {
        this._$3978.add(0, task);
        ++this._$4001;
        return task.id;
    }

    public void createNewTaskList(long taskListID) {
        this._$3978.removeAllElements();
        this._$3980 = taskListID;
    }

    public void executeTaskList() {
        if (this._$3999) {
            Utils.centerDialog(this._$3977, this);
        }
        this._$3999 = false;
        this._$4064();
        if (this.isWorkingOffline()) {
            Timer timerToClickStart = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    IPasLibrarian.this.btnStart.doClick();
                }
            });
            timerToClickStart.setRepeats(false);
            timerToClickStart.start();
        }
        if (Utils.isMacintosh()) {
            Timer refresh = new Timer(200, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    IPasLibrarian.this.invalidate();
                    IPasLibrarian.this.repaint();
                }
            });
            refresh.setRepeats(false);
            refresh.start();
        }
        this.show();
    }

    public void resumeTasks() {
        this.pausing = false;
    }

    public StudentRoster getStudentRoster() {
        return this._$3976;
    }

    public void clearRoster() {
        this._$3976.removeAll();
    }

    public void saveRoster(String fileName) throws Exception {
        this._$3976.save(fileName);
    }

    public void addStudent(String firstName, String lastName, String studentID, String password, long dbID) {
        this._$3976.addStudent(firstName, lastName, studentID, password, dbID);
    }

    public boolean localRosterFound() {
        return new File(this._$3992 + "students.lst").exists();
    }

    public void deleteLocalRoster() {
        this.clearRoster();
        new File(this._$3992 + "students.lst").delete();
        this._$3975.initialize();
    }

    public StudentRosterItem findStudent(String studentID) {
        if (this._$3976.getStudentCount() == 0) {
            try {
                this._$3976 = new StudentRoster(this._$3992 + "students.lst");
            }
            catch (Exception ex2) {
                return null;
            }
        }
        return this._$3976.findStudent(studentID);
    }

    public StudentRosterItem[] getIPasIDDuplicates() {
        return this._$3976.findDuplicates();
    }

    public long getStudentDBID(String idpwd) throws IPasLibrarianException {
        String studentID;
        String password = null;
        int pos = idpwd.indexOf(46);
        if (pos == -1) {
            studentID = idpwd;
        } else {
            studentID = idpwd.substring(0, pos);
            password = idpwd.substring(pos + 1);
        }
        StudentRosterItem student = this.findStudent(studentID);
        if (student == null) {
            throw new IPasLibrarianException("A student with the ID [" + studentID + "] was not found in the class roster.", IPasLibrarianException.STUDENTID_NOT_FOUND_ERROR);
        }
        if (!student.verifyPassword(password)) {
            throw new IPasLibrarianException("The password for " + student.getFullName() + " is not correct.\nContact your instructor for the correct password.", IPasLibrarianException.INVALID_STUDENT_PASSWORD_ERROR);
        }
        return student.dbID;
    }

    public Frame getMainFrame() {
        return this._$3977;
    }

    public LessonList getLessonList() {
        return this._$3974;
    }

    public boolean canWorkOffline() {
        if (this._$3993 == null) {
            return false;
        }
        return new File(this._$3993).exists();
    }

    public boolean setWorkingOffline(boolean offline) {
        if (!this.canWorkOffline()) {
            return false;
        }
        if (this._$3989 == offline) {
            return true;
        }
        this._$3989 = offline;
        this._$4046();
        return true;
    }

    public boolean isWorkingOffline() {
        return this._$3989;
    }

    public boolean isConnected() {
        if (this.isWorkingOffline()) {
            return true;
        }
        return this._$3973.isConnected();
    }

    public String getLocalPath() {
        return this._$3992;
    }

    public void setTraceLevel(int level) {
        this._$3998 = level;
    }

    public void setUserInstallationVerification(boolean enabled) {
        this._$3970 = enabled;
    }

    public void setExitOnFinish(boolean enabled) {
        this._$3981 = enabled;
    }

    public boolean isOnlineChecked() {
        return this._$3988;
    }

    public boolean isLocalAssessmentAvailable(String studentID, int fileType, long attachmentID) {
        return this._$3975.isLocalFileAvailable(studentID, fileType, attachmentID);
    }

    public boolean isOnlineAssessmentAvailable(String studentID, int fileType, long attachmentID) {
        return this._$3975.isOnlineFileAvailable(studentID, fileType, attachmentID);
    }

    public OnlineFileInfo[] getOnlineOnlyFileList(int fileType) {
        return this._$3975.findOnlyOnline(fileType);
    }

    public synchronized void addListener(IPasLibrarianListener listener) {
        this._$1509.addElement(listener);
    }

    public synchronized void removeListener(IPasLibrarianListener listener) {
        if (listener != null) {
            this._$1509.removeElement(listener);
        }
    }

    private void _$4225() {
        IPasLibrarianEvent e2 = new IPasLibrarianEvent(this);
        for (int i2 = 0; i2 < this._$1509.size(); ++i2) {
            ((IPasLibrarianListener)this._$1509.elementAt(i2)).taskListStarted(e2);
        }
    }

    private void _$4093() {
        IPasLibrarianEvent e2 = new IPasLibrarianEvent(this);
        for (int i2 = 0; i2 < this._$1509.size(); ++i2) {
            ((IPasLibrarianListener)this._$1509.elementAt(i2)).taskListFinished(e2);
        }
    }

    private void _$4210(IPasLibrarianTask task) {
        IPasLibrarianEvent e2 = new IPasLibrarianEvent(this, task);
        for (int i2 = 0; i2 < this._$1509.size(); ++i2) {
            ((IPasLibrarianListener)this._$1509.elementAt(i2)).taskStarted(e2);
        }
    }

    private void _$4229(IPasLibrarianTask task) {
        IPasLibrarianEvent e2 = new IPasLibrarianEvent(this, task);
        for (int i2 = 0; i2 < this._$1509.size(); ++i2) {
            ((IPasLibrarianListener)this._$1509.elementAt(i2)).taskFinished(e2);
        }
    }

    private void _$4094(IPasLibrarianTask task, IPasLibrarianException ex2) {
        IPasLibrarianEvent e2 = new IPasLibrarianEvent(this, task, ex2);
        for (int i2 = 0; i2 < this._$1509.size(); ++i2) {
            ((IPasLibrarianListener)this._$1509.elementAt(i2)).taskListAborted(e2);
        }
    }

    void btnStart_actionPerformed(ActionEvent e2) {
        if (this.btnStart.getText().equalsIgnoreCase("Start")) {
            this._$4224();
        } else if (!this.isConnected()) {
            this.hide();
        } else {
            this._$4044();
        }
    }
}

