/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jbc.beans.JbcSpinButton;
import jbc.grid.JbcCellEditorInteger;
import pyware.iPasToolkit.interactive.AssignmentFile;
import pyware.iPasToolkit.interactive.AssignmentItem;
import pyware.iPasToolkit.interactive.AssignmentList;
import pyware.iPasToolkit.interactive.DetailIconCellRenderer;
import pyware.iPasToolkit.interactive.DueDateCellRenderer;
import pyware.iPasToolkit.interactive.ExtensionCellRenderer;
import pyware.iPasToolkit.interactive.GradeCellRenderer;
import pyware.iPasToolkit.interactive.GradingScheme;
import pyware.iPasToolkit.interactive.IPasDateCellRenderer;
import pyware.iPasToolkit.interactive.IPasLibrarian;
import pyware.iPasToolkit.interactive.IPasStudentTableRow;
import pyware.iPasToolkit.interactive.LessonDescCellRenderer;
import pyware.iPasToolkit.interactive.LessonList;
import pyware.iPasToolkit.interactive.StudentRosterItem;

public class IPasStudentTable
extends AbstractTableModel {
    public static long MILLIS_PER_HOUR = 3600000L;
    public static long MILLIS_PER_DAY = MILLIS_PER_HOUR * 24L;
    public static int TEACHER_EDIT = 0;
    public static int STUDENT_EDIT = 1;
    public static int STUDENT_LOG_VERSION = 1;
    public static int LESSON_DESC = 0;
    public static int ASSIGNED_COLUMN = 1;
    public static int DUE_COLUMN = 2;
    public static int COMPLETED_COLUMN = 3;
    public static int GRADE_COLUMN = 4;
    public static int EXTENSION_COLUMN = 5;
    public static int GRADE_LOCK_COLUMN = 6;
    public static int ATTACHMENT_COLUMN = 7;
    private String _$8336 = "";
    private String _$4265 = null;
    private StudentRosterItem _$8337 = null;
    private int _$8338 = TEACHER_EDIT;
    private Vector _$8339 = new Vector();
    private JTable _$8323;
    private boolean _$8340 = true;
    private GradingScheme _$8341 = null;
    private long _$8342 = 0L;

    public IPasStudentTable() {
    }

    public IPasStudentTable(String iPasStudentID) {
        this._$8336 = iPasStudentID;
    }

    public IPasStudentTable(String iPasStudentID, String password) {
        this._$8336 = iPasStudentID;
        this._$4265 = password;
    }

    public IPasStudentTable(StudentRosterItem student) {
        this._$8337 = student;
        this._$8336 = student.iPasID;
        this._$4265 = student.password;
    }

    private static String _$8343(DataInputStream is) throws Exception {
        byte[] array = new byte[is.readByte()];
        is.read(array);
        return new String(array).trim();
    }

    public void sort() {
        if (this._$8338 == TEACHER_EDIT) {
            return;
        }
        boolean sorted = false;
        int len = this.getRowCount();
        for (int a10 = 0; a10 < len; ++a10) {
            for (int b2 = a10 + 1; b2 < len; ++b2) {
                String descB;
                String descA;
                Timestamp dueB;
                Timestamp dueA = (Timestamp)this.getValueAt(a10, DUE_COLUMN);
                if (dueA.after(dueB = (Timestamp)this.getValueAt(b2, DUE_COLUMN))) {
                    sorted = true;
                    Object objA = this._$8339.elementAt(a10);
                    Object objB = this._$8339.elementAt(b2);
                    this._$8339.setElementAt(objA, b2);
                    this._$8339.setElementAt(objB, a10);
                    continue;
                }
                if (!dueA.equals(dueB) || (descA = (String)this.getValueAt(a10, LESSON_DESC)).compareToIgnoreCase(descB = (String)this.getValueAt(b2, LESSON_DESC)) <= 0) continue;
                sorted = true;
                Object objA = this._$8339.elementAt(a10);
                Object objB = this._$8339.elementAt(b2);
                this._$8339.setElementAt(objA, b2);
                this._$8339.setElementAt(objB, a10);
            }
        }
        if (sorted) {
            this.fireTableDataChanged();
        }
    }

    public void fireTableDataChanged() {
        this.recalculateOverallGrade();
        super.fireTableDataChanged();
    }

    public void writeStudentLog(String fileName) throws Exception {
        DataOutputStream os = new DataOutputStream(new FileOutputStream(fileName));
        os.writeShort(STUDENT_LOG_VERSION);
        os.writeByte(this._$8336.length());
        os.write(this._$8336.getBytes());
        int totalItems = this.getRowCount();
        for (int i2 = 0; i2 < totalItems; ++i2) {
            IPasStudentTableRow item = this.getRowAt(i2);
            if (item.isEmpty()) continue;
            item.writeToLogFile(os);
        }
        os.writeLong(0L);
        os.close();
    }

    public static IPasStudentTable readStudentLog(String fileName) throws Exception {
        IPasStudentTableRow item;
        DataInputStream is = new DataInputStream(new FileInputStream(fileName));
        short version = is.readShort();
        if (version > STUDENT_LOG_VERSION) {
            throw new Exception("Incompatible version of " + fileName);
        }
        IPasStudentTable data = new IPasStudentTable(IPasStudentTable._$8343(is));
        while ((item = IPasStudentTableRow.createFromLogFile(is)) != null) {
            data.addRow(item);
        }
        is.close();
        data.sort();
        return data;
    }

    public static IPasStudentTable buildCurrentStudentLog(String localPath, StudentRosterItem student, String sn) throws Exception {
        String fileName = localPath + student.dbID + ".asn";
        AssignmentFile asn = new AssignmentFile(fileName, student.iPasID);
        AssignmentList assignments = asn.getAssignmentList();
        IPasStudentTable result = new IPasStudentTable(student);
        result._$8342 = asn.getCreationDate();
        result._$8340 = asn.isTop10Enabled();
        result._$8341 = asn.getGradingScheme();
        result.mergeAssignmentList(assignments);
        IPasStudentTableRow[] studentAsnInfo = asn.getStudentAsnInfo();
        for (int i2 = 0; i2 < studentAsnInfo.length; ++i2) {
            IPasStudentTableRow assignment = studentAsnInfo[i2];
            IPasStudentTableRow existingAssignment = result.find(assignment.lessonID);
            if (existingAssignment == null) continue;
            existingAssignment.gradeSummary.setValues(assignment.gradeSummary);
            existingAssignment.studentModifier.setValues(assignment.studentModifier);
        }
        fileName = localPath + student.iPasID + '.' + sn + ".log";
        if (new File(fileName).exists()) {
            IPasStudentTable backupLog = IPasStudentTable.readStudentLog(fileName);
            int len = result.getRowCount();
            for (int i3 = 0; i3 < len; ++i3) {
                IPasStudentTableRow item = result.getRowAt(i3);
                IPasStudentTableRow backupItem = backupLog.find(item.lessonID);
                item.mergeBackupLogItem(backupItem);
            }
        }
        result.sort();
        return result;
    }

    public void setGradingScheme(GradingScheme gradingScheme) {
        this._$8341 = gradingScheme;
        gradingScheme.recalcOverallGrade(this);
    }

    public void setTable(JTable aTable, IPasLibrarian librarian, GradingScheme gradingScheme) {
        JbcSpinButton button;
        JbcCellEditorInteger editor;
        this._$8323 = aTable;
        this._$8323.setModel(this);
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            TableColumn tableColumn = this._$8323.getColumnModel().getColumn(i2);
            if (i2 == LESSON_DESC) {
                tableColumn.setPreferredWidth(1000);
                tableColumn.setCellRenderer(new LessonDescCellRenderer(this));
            }
            if (i2 == GRADE_COLUMN) {
                tableColumn.setMinWidth(this.getColumnWidth(i2));
                tableColumn.setCellRenderer(new GradeCellRenderer(this));
                tableColumn.setCellEditor(new JbcCellEditorInteger(-1, 100));
            }
            if (i2 == EXTENSION_COLUMN) {
                tableColumn.setMinWidth(this.getColumnWidth(i2));
                tableColumn.setCellRenderer(new ExtensionCellRenderer(this));
                tableColumn.setCellEditor(new JbcCellEditorInteger(0, 100));
            }
            if (i2 == COMPLETED_COLUMN) {
                tableColumn.setMinWidth(this.getColumnWidth(i2));
                tableColumn.setCellRenderer(new IPasDateCellRenderer(3));
            }
            if (i2 == ASSIGNED_COLUMN) {
                tableColumn.setMinWidth(this.getColumnWidth(i2));
                tableColumn.setCellRenderer(new IPasDateCellRenderer(3));
            }
            if (i2 == DUE_COLUMN) {
                tableColumn.setMinWidth(this.getColumnWidth(i2));
                DueDateCellRenderer renderer = new DueDateCellRenderer(3);
                tableColumn.setCellRenderer(renderer);
            }
            if (i2 != ATTACHMENT_COLUMN) continue;
            tableColumn.setMinWidth(this.getColumnWidth(i2));
            tableColumn.setMaxWidth(this.getColumnWidth(i2));
            tableColumn.setCellRenderer(new DetailIconCellRenderer(this, librarian));
        }
        if (EXTENSION_COLUMN < this.getColumnCount()) {
            TableColumn column = this._$8323.getColumnModel().getColumn(EXTENSION_COLUMN);
            editor = (JbcCellEditorInteger)column.getCellEditor();
            button = (JbcSpinButton)editor.getComponent();
            button.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e2) {
                    int row = IPasStudentTable.this._$8323.getEditingRow();
                    if (row == -1) {
                        return;
                    }
                    int value = ((JbcSpinButton)e2.getSource()).getValue();
                    IPasStudentTable.this._$8323.setValueAt(new Integer(value), row, EXTENSION_COLUMN);
                }
            });
        }
        TableColumn column = this._$8323.getColumnModel().getColumn(GRADE_COLUMN);
        editor = (JbcCellEditorInteger)column.getCellEditor();
        button = (JbcSpinButton)editor.getComponent();
        button.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                int row = IPasStudentTable.this._$8323.getEditingRow();
                if (row == -1) {
                    return;
                }
                int value = ((JbcSpinButton)e2.getSource()).getValue();
                IPasStudentTable.this._$8323.setValueAt(new Integer(value), row, GRADE_COLUMN);
            }
        });
        if (gradingScheme != null) {
            this.setGradingScheme(gradingScheme);
        } else {
            this.recalculateOverallGrade();
        }
    }

    public int getRowCount() {
        return this._$8339.size();
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == LESSON_DESC) {
            return String.class;
        }
        if (columnIndex == COMPLETED_COLUMN) {
            return Timestamp.class;
        }
        if (columnIndex == ASSIGNED_COLUMN) {
            return Timestamp.class;
        }
        if (columnIndex == DUE_COLUMN) {
            return Timestamp.class;
        }
        if (columnIndex == GRADE_COLUMN) {
            return String.class;
        }
        if (columnIndex == GRADE_LOCK_COLUMN) {
            return Boolean.class;
        }
        if (columnIndex == EXTENSION_COLUMN) {
            return Integer.class;
        }
        if (columnIndex == ATTACHMENT_COLUMN) {
            return Long.class;
        }
        return String.class;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == LESSON_DESC) {
            return "Lesson";
        }
        if (columnIndex == COMPLETED_COLUMN) {
            return "Finished";
        }
        if (columnIndex == ASSIGNED_COLUMN) {
            return "Assigned";
        }
        if (columnIndex == DUE_COLUMN) {
            return "Due";
        }
        if (columnIndex == GRADE_LOCK_COLUMN) {
            return "Lock";
        }
        if (columnIndex == GRADE_COLUMN) {
            if (this._$8341 != null) {
                if (this._$8341.gradeStyle == GradingScheme.GRADE_STYLE_MERIT) {
                    return "Grd|Pt";
                }
            }
            return "Grade";
        }
        if (columnIndex == EXTENSION_COLUMN) {
            return "Extend";
        }
        if (columnIndex == ATTACHMENT_COLUMN) {
            return "Go ->";
        }
        return "";
    }

    public int getColumnWidth(int columnIndex) {
        if (columnIndex == LESSON_DESC) {
            return 350;
        }
        if (columnIndex == COMPLETED_COLUMN) {
            return 50;
        }
        if (columnIndex == ASSIGNED_COLUMN) {
            return 50;
        }
        if (columnIndex == DUE_COLUMN) {
            return 50;
        }
        if (columnIndex == GRADE_LOCK_COLUMN) {
            return 50;
        }
        if (columnIndex == GRADE_COLUMN) {
            return 30;
        }
        if (columnIndex == EXTENSION_COLUMN) {
            return 30;
        }
        if (columnIndex == ATTACHMENT_COLUMN) {
            return 43;
        }
        return 0;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this._$8338 == STUDENT_EDIT) {
            return false;
        }
        if (columnIndex == EXTENSION_COLUMN) {
            return true;
        }
        if (columnIndex == GRADE_LOCK_COLUMN) {
            return true;
        }
        return columnIndex == GRADE_COLUMN;
    }

    public int getColumnCount() {
        if (this._$8338 == TEACHER_EDIT) {
            return 8;
        }
        return 5;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        IPasStudentTableRow row = this.getRowAt(rowIndex);
        if (columnIndex == LESSON_DESC) {
            return row.description;
        }
        if (columnIndex == COMPLETED_COLUMN) {
            return new Timestamp(row.gradeSummary.completionDateTime);
        }
        if (columnIndex == ASSIGNED_COLUMN) {
            return new Timestamp(row.classModifier.assignedDate);
        }
        if (columnIndex == DUE_COLUMN) {
            return new Timestamp(row.classModifier.dueDate + (long)row.studentModifier.extension * MILLIS_PER_DAY);
        }
        if (columnIndex == GRADE_COLUMN) {
            if (row.isCompleted()) {
                return new Integer(row.gradeSummary.grade);
            }
            return new Integer(-1);
        }
        if (columnIndex == GRADE_LOCK_COLUMN) {
            return new Boolean(row.studentModifier.isLocked());
        }
        if (columnIndex == EXTENSION_COLUMN) {
            return new Integer(row.studentModifier.extension);
        }
        if (columnIndex == ATTACHMENT_COLUMN) {
            return new Long(row.gradeDetail.attachmentID);
        }
        return "";
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        IPasStudentTableRow row = this.getRowAt(rowIndex);
        if (columnIndex == EXTENSION_COLUMN) {
            row.studentModifier.extension = ((Integer)value).byteValue();
            row.studentModifier.gradeLock = 0;
            this.fireTableCellUpdated(rowIndex, GRADE_LOCK_COLUMN);
            this.fireTableCellUpdated(rowIndex, DUE_COLUMN);
        }
        if (columnIndex == GRADE_COLUMN) {
            int grade = (Integer)value;
            if (grade == -1) {
                row.gradeSummary.completionDateTime = 0L;
                row.studentModifier.gradeLock = 0;
                this.fireTableCellUpdated(rowIndex, GRADE_LOCK_COLUMN);
                this.fireTableCellUpdated(rowIndex, COMPLETED_COLUMN);
            } else {
                if (!row.isCompleted()) {
                    row.gradeSummary.completionDateTime = System.currentTimeMillis();
                }
                row.gradeSummary.grade = (byte)grade;
                row.studentModifier.gradeLock = 1;
                this.fireTableCellUpdated(rowIndex, GRADE_LOCK_COLUMN);
                this.fireTableCellUpdated(rowIndex, COMPLETED_COLUMN);
            }
        }
        if (columnIndex == GRADE_LOCK_COLUMN) {
            row.studentModifier.gradeLock = (Boolean)value != false ? (byte)1 : 0;
        }
    }

    public void addRow(IPasStudentTableRow row) {
        this._$8339.addElement(row);
        this.fireTableDataChanged();
    }

    public void removeRow(int index) {
        this._$8339.removeElementAt(index);
        this.fireTableDataChanged();
    }

    public void removeAllRows() {
        this._$8339.removeAllElements();
        this.fireTableDataChanged();
    }

    public IPasStudentTableRow getRowAt(int rowIndex) {
        return (IPasStudentTableRow)this._$8339.elementAt(rowIndex);
    }

    public IPasStudentTableRow find(long lessonID) {
        int len = this.getRowCount();
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.getRowAt((int)i2).lessonID != lessonID) continue;
            return this.getRowAt(i2);
        }
        return null;
    }

    public void setEditMode(int mode) {
        this._$8338 = mode;
    }

    public int getEditMode() {
        return this._$8338;
    }

    public String getIPasID() {
        return this._$8336;
    }

    public String getPassword() {
        if (this._$4265 == null) {
            return "";
        }
        return this._$4265;
    }

    public void setPassword(String password) {
        this._$4265 = password;
    }

    public void setIPasID(String id) {
        this._$8336 = id;
    }

    public String getName() {
        if (this._$8337 == null) {
            return "";
        }
        return this._$8337.firstName + ' ' + this._$8337.lastName;
    }

    public boolean isTop10Enabled() {
        return this._$8340;
    }

    public GradingScheme getGradingScheme() {
        return this._$8341;
    }

    public int recalculateOverallGrade() {
        if (this._$8341 != null) {
            this._$8341.recalcOverallGrade(this);
            return this._$8341.grade;
        }
        return -1;
    }

    public void mergeAssignmentList(AssignmentList assignmentList) {
        int len = assignmentList.assignmentCount();
        for (int i2 = 0; i2 < len; ++i2) {
            AssignmentItem assignment = assignmentList.assignmentAt(i2);
            if (!assignment.assigned) continue;
            IPasStudentTableRow studentItem = this.find(assignment.lessonID);
            if (studentItem == null) {
                this.addRow(new IPasStudentTableRow(assignment));
                continue;
            }
            studentItem.classModifier.setValues(assignment);
        }
        this.sort();
    }

    public void updateStudentInfo(IPasStudentTable newData) {
        int len = newData.getRowCount();
        for (int i2 = 0; i2 < len; ++i2) {
            IPasStudentTableRow newItem = newData.getRowAt(i2);
            IPasStudentTableRow item = this.find(newItem.lessonID);
            if (item == null) continue;
            long existDataCompletion = item.getCompletionDateTime();
            int existTimer = item.getTimer();
            item.gradeSummary.setValues(newItem.gradeSummary);
            item.gradeDetail.setValues(newItem.gradeDetail);
            item.studentModifier.setValues(newItem.studentModifier);
            if (existDataCompletion == item.getCompletionDateTime()) continue;
            item.setTimer(existTimer + item.getTimer());
        }
        this.sort();
    }

    public void mergeLessonDescriptions(LessonList lessonList) {
        int len = this.getRowCount();
        for (int i2 = 0; i2 < len; ++i2) {
            this.getRowAt(i2).setDescription(lessonList);
        }
    }

    public long getAsnFileCreationDate() {
        return this._$8342;
    }
}

