/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

public class OnlineFileInfo {
    public static int ANNOUNCEMENT;
    public static int ASSIGNMENT_LIST;
    public static long MILLIS_PER_DAY;
    public static long MILLIS_PER_HOUR;
    public static int STUDENT_ASSESSMENT_LOG;
    public static int STUDENT_ASSESSMENT_PNG;
    public static int STUDENT_ASSESSMENT_WAV;
    public static int STUDENT_ROSTER;
    public static int UNKNOWN;
    private long _$7737 = 0L;
    private String _$474;
    private int _$7736 = UNKNOWN;
    private String _$10392 = null;
    private boolean _$10388 = false;
    private boolean _$10389 = false;
    private long _$10391 = 0L;
    private String _$10390 = null;
    private String _$6842 = null;

    static {
        MILLIS_PER_HOUR = 3600000L;
        MILLIS_PER_DAY = MILLIS_PER_HOUR * 24L;
        UNKNOWN = 0;
        STUDENT_ASSESSMENT_LOG = 2;
        STUDENT_ASSESSMENT_WAV = 3;
        STUDENT_ASSESSMENT_PNG = 4;
        STUDENT_ROSTER = 5;
        ASSIGNMENT_LIST = 6;
        ANNOUNCEMENT = 7;
    }

    public OnlineFileInfo(String fileName, String fileTime, boolean localCopy, boolean onlineCopy, long onlineSize) {
        this._$474 = fileName;
        this._$10390 = fileTime;
        this._$10388 = localCopy;
        this._$10389 = onlineCopy;
        this._$10391 = onlineSize;
        this._$7736 = OnlineFileInfo.extractFileType(fileName);
        if (this._$7736 == STUDENT_ASSESSMENT_LOG | this._$7736 == STUDENT_ASSESSMENT_WAV | this._$7736 == STUDENT_ASSESSMENT_PNG) {
            this._$6842 = OnlineFileInfo.extractStudentID(fileName);
            this._$7737 = OnlineFileInfo.extractAttachmentID(fileName);
        }
    }

    public OnlineFileInfo() {
    }

    public static OnlineFileInfo createLocalFileInfo(String fileName) {
        OnlineFileInfo info = new OnlineFileInfo(fileName, null, true, false, 0L);
        return info;
    }

    public static OnlineFileInfo createOnlineFileInfo(String fileName, String fileTime, long fileSize) {
        OnlineFileInfo info = new OnlineFileInfo(fileName, fileTime, false, true, fileSize);
        return info;
    }

    public static long extractAttachmentID(String fileName) {
        int pos = fileName.indexOf(46);
        long aID = 0L;
        if (pos != -1) {
            String sub = fileName.substring(0, pos);
            try {
                aID = Long.parseLong(sub, 16);
            }
            catch (NumberFormatException ex2) {
            }
        }
        return aID;
    }

    public static int extractFileType(String fileName) {
        if (fileName.endsWith(".lst")) {
            return STUDENT_ROSTER;
        }
        if (fileName.endsWith(".asn")) {
            return ASSIGNMENT_LIST;
        }
        if (fileName.endsWith(".anc")) {
            return ANNOUNCEMENT;
        }
        if (fileName.endsWith(".log")) {
            return STUDENT_ASSESSMENT_LOG;
        }
        if (fileName.endsWith(".png")) {
            return STUDENT_ASSESSMENT_PNG;
        }
        if (fileName.endsWith(".wav")) {
            return STUDENT_ASSESSMENT_WAV;
        }
        return UNKNOWN;
    }

    public static String extractStudentID(String fileName) {
        int pos1 = fileName.indexOf(46) + 1;
        int pos2 = fileName.indexOf(46, pos1 + 1);
        if (pos2 == -1) {
            return "";
        }
        return fileName.substring(pos1, pos2);
    }

    public int getAge() {
        long id = OnlineFileInfo.extractAttachmentID(this._$474);
        long msec = System.currentTimeMillis() - id;
        return new Long(msec / MILLIS_PER_DAY).intValue();
    }

    public long getAttachmentID() {
        return this._$7737;
    }

    public String getDownloadTime() {
        return this._$10392;
    }

    public String getFileName() {
        return this._$474;
    }

    public int getFileType() {
        return this._$7736;
    }

    public long getOnlineFileSize() {
        return this._$10391;
    }

    public String getStudentID() {
        return this._$6842;
    }

    public boolean isDownloadCurrent() {
        if (this._$10392 == null) {
            return false;
        }
        if (this._$10390 == null) {
            return false;
        }
        if (!this._$10388) {
            return false;
        }
        return this._$10392.equalsIgnoreCase(this._$10390);
    }

    public boolean isLocal() {
        return this._$10388;
    }

    public boolean isOnline() {
        return this._$10389;
    }

    public boolean matches(OnlineFileInfo item) {
        return this._$6842.compareToIgnoreCase(item._$6842) == 0 && this._$7737 == item._$7737 && this._$7736 == item._$7736;
    }

    public boolean matches(String aStudentID, long aAttachmentID, int aFileType) {
        if (this._$6842 == null && aStudentID != null) {
            return false;
        }
        if (this._$6842 != null && aStudentID == null) {
            return false;
        }
        if (this._$6842 == null && aStudentID == null) {
            return this._$7737 == aAttachmentID && aFileType == this._$7736;
        }
        return this._$6842.compareToIgnoreCase(aStudentID) == 0 && this._$7737 == aAttachmentID && aFileType == this._$7736;
    }

    public void setFileDownloaded() {
        if (this._$10390 == null) {
            this.setLastDownloadTime(null);
        } else {
            this.setLastDownloadTime(new String(this._$10390));
        }
        this.setHasLocalCopy();
    }

    public void setHasLocalCopy() {
        this._$10388 = true;
    }

    public void setLastDownloadTime(String time) {
        this._$10392 = time;
    }

    public void setOnlineTime(String fileTime) {
        this._$10390 = fileTime;
        this._$10389 = true;
    }

    public String toString() {
        return this._$474;
    }
}

