/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit.interactive;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import pyware.iPasToolkit.interactive.OnlineFileInfo;
import pyware.toolkit.FileUtils;

public class OnlineFileList {
    Vector list = new Vector();
    String localPath;

    public OnlineFileList(String localPath) {
        this.localPath = localPath;
        this.initialize();
    }

    public void initialize() {
        this.list.removeAllElements();
        if (this.localPath == null) {
            return;
        }
        this.rescanForLocal();
        this._$6820();
    }

    private void _$6820() {
        File file = new File(this.localPath + "download.stamps");
        if (!file.exists()) {
            return;
        }
        try {
            DataInputStream is = new DataInputStream(new FileInputStream(file));
            int len = is.readShort();
            for (int i2 = 0; i2 < len; ++i2) {
                String fileName = is.readUTF();
                String fileDate = is.readUTF();
                OnlineFileInfo info = this.find(fileName);
                if (info == null) continue;
                info.setLastDownloadTime(fileDate);
            }
            is.close();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public void saveDownloadTimes() {
        try {
            int i2;
            DataOutputStream os = new DataOutputStream(new FileOutputStream(this.localPath + "download.stamps"));
            int len = this.list.size();
            int count = 0;
            for (i2 = 0; i2 < len; ++i2) {
                if (this._$6809(i2).getDownloadTime() == null) continue;
                ++count;
            }
            os.writeShort(count);
            for (i2 = 0; i2 < len; ++i2) {
                OnlineFileInfo info = this._$6809(i2);
                if (info.getDownloadTime() == null) continue;
                os.writeUTF(info.getFileName());
                os.writeUTF(info.getDownloadTime());
            }
            os.close();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    private OnlineFileInfo _$6809(int index) {
        return (OnlineFileInfo)this.list.elementAt(index);
    }

    public boolean isLocalFileAvailable(String studentID, int fileType, long attachmentID) {
        for (int i2 = 0; i2 < this.list.size(); ++i2) {
            OnlineFileInfo item = this._$6809(i2);
            if (!item.matches(studentID, attachmentID, fileType) || !item.isLocal()) continue;
            return true;
        }
        return false;
    }

    public boolean isOnlineFileAvailable(String studentID, int fileType, long attachmentID) {
        for (int i2 = 0; i2 < this.list.size(); ++i2) {
            OnlineFileInfo item = this._$6809(i2);
            if (!item.matches(studentID, attachmentID, fileType) || !item.isOnline()) continue;
            return true;
        }
        return false;
    }

    public void updateOnlineFileInfo(String fileName, String fileTime, long fileSize) {
        OnlineFileInfo info = this.find(fileName);
        if (info == null) {
            this.list.add(OnlineFileInfo.createOnlineFileInfo(fileName, fileTime, fileSize));
        } else {
            info.setOnlineTime(fileTime);
        }
    }

    public void markFileDownloaded(String fileName) {
        OnlineFileInfo info = this.find(fileName);
        if (info == null) {
            return;
        }
        info.setFileDownloaded();
        this.saveDownloadTimes();
    }

    public OnlineFileInfo find(String fileName) {
        for (int i2 = 0; i2 < this.list.size(); ++i2) {
            OnlineFileInfo item = this._$6809(i2);
            if (!item.getFileName().equalsIgnoreCase(fileName)) continue;
            return item;
        }
        return null;
    }

    public OnlineFileInfo find(OnlineFileInfo info) {
        return this.find(info.getFileName());
    }

    public OnlineFileInfo[] findOnlyOnline(int fileType) {
        Vector<OnlineFileInfo> rslt = new Vector<OnlineFileInfo>();
        int len = this.list.size();
        for (int i2 = 0; i2 < len; ++i2) {
            OnlineFileInfo info = this._$6809(i2);
            if (info.getFileType() != fileType) continue;
            if (info.isOnline() && !info.isLocal()) {
                rslt.addElement(info);
            }
            if (!info.isOnline() || !info.isLocal() || info.isDownloadCurrent()) continue;
            rslt.addElement(info);
        }
        Object[] rsltArray = new OnlineFileInfo[rslt.size()];
        rslt.copyInto(rsltArray);
        return rsltArray;
    }

    public OnlineFileInfo[] findOnlineExpired(int maxAge) {
        int i2;
        Vector<Object> result = new Vector<Object>();
        Object[] list = this.findOnlyOnline(OnlineFileInfo.STUDENT_ASSESSMENT_WAV);
        for (i2 = 0; i2 < list.length; ++i2) {
            if (list[i2].getAge() <= maxAge) continue;
            result.add(list[i2]);
        }
        list = this.findOnlyOnline(OnlineFileInfo.STUDENT_ASSESSMENT_PNG);
        for (i2 = 0; i2 < list.length; ++i2) {
            if (list[i2].getAge() <= maxAge) continue;
            result.add(list[i2]);
        }
        list = new OnlineFileInfo[result.size()];
        result.copyInto(list);
        return list;
    }

    public void rescanForLocal() {
        String[] fileNames = FileUtils.getFileList(this.localPath);
        for (int i2 = 0; i2 < fileNames.length; ++i2) {
            OnlineFileInfo fileInfo = this.find(fileNames[i2]);
            if (fileInfo != null) {
                fileInfo.setHasLocalCopy();
                continue;
            }
            this.list.add(OnlineFileInfo.createLocalFileInfo(fileNames[i2]));
        }
    }
}

