/*
 * Decompiled with CFR 0.152.
 */
package pyware.toolkit;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Vector;
import pyware.toolkit.Decoder;

public class IniFile {
    private boolean _$227 = false;
    private Vector _$225 = new Vector();
    private URL _$226;

    public IniFile(String filePath) {
        try {
            this.setURL(new URL("file:" + filePath));
            this._$230();
        }
        catch (Exception e2) {
        }
    }

    public IniFile(URL location) {
        try {
            this.setURL(location);
            this._$230();
        }
        catch (Exception e2) {
        }
    }

    public IniFile() {
    }

    private int _$290(String section) {
        this._$225.addElement("");
        this._$225.addElement(this._$289(section));
        int index = this._$225.size() - 1;
        return index;
    }

    private String _$258(String text) {
        StringBuffer result = new StringBuffer();
        int len = text.length();
        int i2 = 0;
        while (i2 < len) {
            int offset = (i2 / 3 + 5) % 10;
            String val = "" + text.charAt(i2) + text.charAt(i2 + 1) + text.charAt(i2 + 2);
            int intVal = Integer.parseInt(val, 16) - offset;
            char ch = (char)intVal;
            result.append(ch);
            i2 += 3;
        }
        return result.toString();
    }

    private String _$250(String value) {
        StringBuffer oldBuffer = new StringBuffer(value);
        StringBuffer newBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < oldBuffer.length()) {
            char chVal = oldBuffer.charAt(i2);
            String val = Integer.toHexString(chVal + (i2 + 5) % 10);
            while (val.length() < 3) {
                val = "0" + val;
            }
            newBuffer.append(val);
            ++i2;
        }
        return newBuffer.toString();
    }

    public boolean getBoolLine(String section, String key, boolean defValue) {
        String defStrValue = "false";
        if (defValue) {
            defStrValue = "true";
        }
        String val = this.getLine(section, key, defStrValue).toLowerCase();
        return val.equals("true") | val.equals("yes") | val.equals("1");
    }

    public Color getColorLine(String section, String key, Color defValue) {
        return this._$292(this.getLine(section, key, this._$302(defValue)));
    }

    public double getDoubleLine(String section, String key, double defValue) {
        try {
            return new Double(this.getLine(section, key, "err"));
        }
        catch (Exception ex2) {
            return defValue;
        }
    }

    public String getEncodedLine(String section, String key, String defValue) {
        String str = this.getLine(section, key, null);
        return str == null ? defValue : this._$258(str);
    }

    public float getFloatLine(String section, String key, float defValue) {
        try {
            return new Float(this.getLine(section, key, "err")).floatValue();
        }
        catch (Exception ex2) {
            return defValue;
        }
    }

    public Font getFontLine(String section, String key, Font font) {
        int fSize;
        int fStyle;
        String fName = this.getFontName(section, key, font);
        Font newFont = new Font(fName, fStyle = this.getFontStyle(section, key, font), fSize = this.getFontSize(section, key, font));
        if (newFont == null) {
            return font;
        }
        return newFont;
    }

    public String getFontName(String section, String key, Font font) {
        String fontName = "";
        if (font != null) {
            fontName = font.getName();
        }
        return this.getLine(section, key + ".name", fontName);
    }

    public int getFontSize(String section, String key, Font font) {
        int fontSize = 12;
        if (font != null) {
            fontSize = font.getSize();
        }
        return this.getIntLine(section, key + ".size", fontSize);
    }

    public int getFontStyle(String section, String key, Font font) {
        int fontStyle = 0;
        if (font != null) {
            fontStyle = font.getStyle();
        }
        return this.getIntLine(section, key + ".style", fontStyle);
    }

    public int getIntLine(String section, String key, int defValue) {
        try {
            return new Integer(this.getLine(section, key, "err"));
        }
        catch (Exception ex2) {
            return defValue;
        }
    }

    public String getLine(String section, String key, String defValue, Decoder decoder) {
        String line = this.getLine(section, key, defValue);
        return line == null ? null : decoder.decode(line);
    }

    public String getLine(String section, String key, String defValue) {
        int index = this._$279(section, key);
        if (index == -1) {
            return defValue;
        }
        String str = this._$248(index);
        return str.substring(this._$282(key).length(), str.length()).trim();
    }

    private int _$279(String section, String key) {
        int startIndex = this._$286(section);
        int stopIndex = this._$287(startIndex);
        return this._$279(key, startIndex, stopIndex);
    }

    private int _$279(String key, int startIndex, int stopIndex) {
        key = this._$282(key).toLowerCase();
        if (startIndex != -1 && stopIndex != -1) {
            int i2 = startIndex;
            while (i2 <= stopIndex) {
                if (this._$248(i2).toLowerCase().startsWith(key)) {
                    return i2;
                }
                ++i2;
            }
        }
        return -1;
    }

    public String[] getListOfSections() {
        Vector<String> list = new Vector<String>();
        int i2 = 0;
        while (i2 < this._$225.size()) {
            String s2 = this._$248(i2);
            if (s2.startsWith("[")) {
                list.addElement(s2.substring(1, s2.length() - 1));
            }
            ++i2;
        }
        String[] stringList = new String[list.size()];
        int i3 = 0;
        while (i3 < list.size()) {
            stringList[i3] = (String)list.elementAt(i3);
            ++i3;
        }
        return stringList;
    }

    public long getLongLine(String section, String key, long defValue) {
        try {
            return new Long(this.getLine(section, key, "err"));
        }
        catch (Exception ex2) {
            return defValue;
        }
    }

    public String[] getSectionList(String section) {
        int start = this._$286(section);
        if (start == -1) {
            return new String[0];
        }
        int stop = this._$287(start);
        Vector<String> list = new Vector<String>();
        int i2 = start + 1;
        while (i2 <= stop) {
            String s2 = this._$248(i2);
            int pos = s2.indexOf(61);
            if (pos != -1) {
                list.add(s2.substring(0, pos));
            } else if (s2.length() > 0 && !s2.startsWith("[")) {
                list.add(s2);
            }
            ++i2;
        }
        String[] result = new String[list.size()];
        int i3 = 0;
        while (i3 < list.size()) {
            result[i3] = (String)list.elementAt(i3);
            ++i3;
        }
        return result;
    }

    public short getShortLine(String section, String key, short defValue) {
        try {
            return new Short(this.getLine(section, key, "err"));
        }
        catch (Exception ex2) {
            return defValue;
        }
    }

    public String[] getStringList(String section, String key) {
        String str = this.getLine(section, key, null);
        if (str == null) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        if (!str.endsWith(";")) {
            str = str + ';';
        }
        int pos1 = 0;
        int pos2 = str.indexOf(59);
        while (pos2 > 0) {
            list.addElement(str.substring(pos1, pos2));
            pos1 = pos2 + 1;
            pos2 = str.indexOf(59, pos1);
        }
        String[] result = new String[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            result[i2] = (String)list.elementAt(i2);
            ++i2;
        }
        return result;
    }

    public Timestamp getTimeStampLine(String section, String key, Timestamp defValue) {
        Timestamp stamp;
        block3: {
            try {
                long longVal = this.getLongLine(section, key, 0L);
                if (longVal == 0L) {
                    stamp = defValue;
                    break block3;
                }
                stamp = new Timestamp(longVal);
            }
            catch (Exception ex2) {
                stamp = defValue;
            }
        }
        return stamp;
    }

    public URL getURL() {
        return this._$226;
    }

    public boolean isChanged() {
        return this._$227;
    }

    public void load(String filePath) throws IOException {
        this.setURL(new URL("file:" + filePath));
        this._$230();
    }

    public void load(URL url) throws IOException {
        this.setURL(url);
        this._$230();
    }

    public void load(File file) throws IOException {
        this.setURL(new URL("file" + file.getAbsoluteFile()));
        this._$230();
    }

    public void load() throws IOException {
        this._$230();
    }

    private int _$287(int index) {
        if (index == -1) {
            return -1;
        }
        int i2 = index + 1;
        while (i2 < this._$225.size()) {
            if (this._$248(i2).toLowerCase().startsWith("[")) {
                return i2;
            }
            ++i2;
        }
        return this._$225.size() - 1;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void _$230() throws IOException {
        String str;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this._$226.openStream()));
        this._$225.removeAllElements();
        while ((str = reader.readLine()) != null) {
            void var2_2;
            this._$225.addElement(var2_2);
        }
        this._$227 = false;
        reader.close();
    }

    public void removeAll() {
        this._$225.removeAllElements();
    }

    private void _$243() {
        boolean thisLineBlank = false;
        boolean previousLineBlank = false;
        int i2 = this._$225.size() - 1;
        while (i2 >= 0) {
            boolean bl2 = thisLineBlank = this._$248(i2).trim().length() == 0;
            if (previousLineBlank && thisLineBlank) {
                this._$225.removeElementAt(i2 + 1);
                this._$227 = true;
            }
            previousLineBlank = thisLineBlank;
            --i2;
        }
        if (this._$225.size() > 0 && this._$248(0).length() == 0) {
            this._$225.removeElementAt(0);
        }
    }

    public void removeLine(String section, String key) {
        int index = this._$279(section, key);
        if (index == -1) {
            return;
        }
        this._$225.removeElementAt(index);
        this._$227 = true;
    }

    public void removeSection(String section) {
        int start = this._$286(section);
        if (start == -1) {
            return;
        }
        int stop = this._$287(start);
        if (stop == this._$225.size() - 1 && !this._$248(stop).startsWith("[")) {
            ++stop;
        }
        int i2 = stop - 1;
        while (i2 >= start) {
            this._$225.removeElementAt(i2);
            this._$227 = true;
            --i2;
        }
    }

    public void renameSection(String oldSection, String newSection) {
        int index = this._$286(oldSection);
        if (index == -1) {
            return;
        }
        this._$225.setElementAt(this._$289(newSection), index);
        this._$227 = true;
    }

    private String _$282(String key) {
        if (!(key = key.trim()).endsWith("=")) {
            key = key + "=";
        }
        return key;
    }

    private String _$289(String section) {
        if (!(section = section.trim()).startsWith("[")) {
            section = "[" + section;
        }
        if (!section.endsWith("]")) {
            section = section + "]";
        }
        return section;
    }

    public void save() throws IOException {
        if (this._$227) {
            this._$240();
        }
    }

    public void saveAs(String filePath) throws IOException {
        this.setURL(new URL("file:" + filePath));
        this._$240();
    }

    private int _$286(String section) {
        section = this._$289(section).toLowerCase();
        int i2 = 0;
        while (i2 < this._$225.size()) {
            if (this._$248(i2).toLowerCase().startsWith(section)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public void setBoolLine(String section, String key, boolean value) {
        if (value) {
            this.setLine(section, key, "true");
        } else {
            this.setLine(section, key, "false");
        }
    }

    public void setColorLine(String section, String key, Color color) {
        this.setLine(section, key, this._$302(color));
    }

    public void setData(String data) {
        if (!data.endsWith("\n")) {
            data = data + '\n';
        }
        this._$225.removeAllElements();
        int begin = 0;
        int end = 0;
        while (end < data.length()) {
            if (data.charAt(end) == '\n') {
                String substring = data.substring(begin, end);
                this._$225.addElement(substring);
                begin = end + 1;
            }
            ++end;
        }
        this._$227 = true;
    }

    public void setDoubleLine(String section, String key, double value) {
        this.setLine(section, key, new Double(value).toString());
    }

    public void setEncodedLine(String section, String key, String value) {
        this.setLine(section, key, this._$250(value));
    }

    public void setFloatLine(String section, String key, float value) {
        this.setLine(section, key, new Float(value).toString());
    }

    public void setFontLine(String section, String key, Font font) {
        if (font == null) {
            return;
        }
        this.setLine(section, key + ".name", font.getFontName());
        this.setIntLine(section, key + ".style", font.getStyle());
        this.setIntLine(section, key + ".size", font.getSize());
    }

    public void setIntLine(String section, String key, int value) {
        this.setLine(section, key, new Integer(value).toString());
    }

    public void setLine(String section, String key, String value) {
        int startIndex = this._$286(section);
        if (startIndex == -1) {
            startIndex = this._$290(section);
        }
        int stopIndex = this._$287(startIndex);
        int index = this._$279(key, startIndex, stopIndex);
        value = this._$282(key) + value;
        if (index != -1) {
            this._$225.setElementAt(value, index);
        } else if (startIndex == this._$225.size() - 1) {
            this._$225.addElement(value);
        } else {
            this._$225.insertElementAt(value, startIndex + 1);
        }
        this._$227 = true;
    }

    public void setLongLine(String section, String key, long value) {
        this.setLine(section, key, new Long(value).toString());
    }

    public void setShortLine(String section, String key, short value) {
        this.setLine(section, key, new Short(value).toString());
    }

    public void setStringList(String section, String key, String[] list) {
        StringBuffer strBuf = new StringBuffer();
        int i2 = 0;
        while (i2 < list.length) {
            if (i2 > 0) {
                strBuf.append(';');
            }
            strBuf.append(list[i2]);
            ++i2;
        }
        this.setLine(section, key, strBuf.toString());
    }

    public void setTimeStampLine(String section, String key, Timestamp time) {
        this.setLine(section, key, Long.toString(time.getTime()));
    }

    public void setURL(URL url) {
        this._$226 = url;
        this._$227 = true;
    }

    private String _$248(int index) {
        return (String)this._$225.elementAt(index);
    }

    private Color _$292(String str) {
        int start = 0;
        int colorIndex = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        str = str + ",";
        int len = str.length();
        int i2 = 0;
        while (i2 < len) {
            if (str.charAt(i2) == ',') {
                String smStr = str.substring(start, i2);
                start = i2 + 1;
                try {
                    if (colorIndex == 0) {
                        red = new Integer(smStr);
                    }
                    if (colorIndex == 1) {
                        green = new Integer(smStr);
                    }
                    if (colorIndex == 2) {
                        blue = new Integer(smStr);
                    }
                    ++colorIndex;
                }
                catch (Exception ex2) {
                }
            }
            ++i2;
        }
        return new Color(red, green, blue);
    }

    private String _$302(Color aColor) {
        return new Integer(aColor.getRed()).toString() + "," + new Integer(aColor.getGreen()).toString() + "," + new Integer(aColor.getBlue()).toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < this._$225.size()) {
            buffer.append((String)this._$225.elementAt(i2));
            buffer.append('\n');
            ++i2;
        }
        return buffer.toString();
    }

    private synchronized void _$240() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this._$226.getPath()));
        this._$243();
        int num = this._$225.size();
        int i2 = 0;
        while (i2 < num) {
            writer.write(this._$248(i2));
            writer.newLine();
            ++i2;
        }
        writer.close();
        this._$227 = false;
    }
}

