/*
 * Decompiled with CFR 0.152.
 */
package pyware.toolkit;

public class KeyCodeFactory {
    public static long DAYS_BEFORE_2002;
    public static long MSEC_PER_DAY;

    static {
        MSEC_PER_DAY = 86400000L;
        DAYS_BEFORE_2002 = 11680L;
    }

    public static String appendKey(String keyCode, String licenseTo, String seed) {
        if ((licenseTo = KeyCodeFactory.sanitizeName(licenseTo)).length() == 0) {
            keyCode = "N" + keyCode;
        }
        return keyCode + KeyCodeFactory.makeKey(KeyCodeFactory.charSum(keyCode) + KeyCodeFactory.charSum(licenseTo) + KeyCodeFactory.charSum(seed));
    }

    public static String appendKey(String keyCode, String licenseTo) {
        if ((licenseTo = KeyCodeFactory.sanitizeName(licenseTo)).length() == 0) {
            keyCode = "N" + keyCode;
        }
        return keyCode + KeyCodeFactory.makeKey(KeyCodeFactory.charSum(keyCode) + KeyCodeFactory.charSum(licenseTo));
    }

    public static String appendKey(String keyCode) {
        return keyCode + KeyCodeFactory.makeKey(KeyCodeFactory.charSum(keyCode));
    }

    public static int charSum(String str) {
        int len = str.length();
        int sum = 0;
        int i2 = 0;
        while (i2 < len) {
            char ch = str.charAt(i2);
            if (ch != '-') {
                sum += (byte)ch;
            }
            ++i2;
        }
        return sum;
    }

    public static String getRealComputerID() {
        long sum = KeyCodeFactory.charSum(System.getProperty("user.name", "")) + KeyCodeFactory.charSum(System.getProperty("os.name", "")) + KeyCodeFactory.charSum(System.getProperty("os.arch", ""));
        return Long.toHexString(sum).toUpperCase();
    }

    public static String makeHostPrefixParam(String hostPrefix, boolean accessEnabled) {
        if (hostPrefix == null) {
            hostPrefix = hostPrefix + "";
        }
        if (!accessEnabled) {
            hostPrefix = 'X' + hostPrefix;
        }
        if (hostPrefix.length() == 0) {
            return "";
        }
        return "-H" + hostPrefix.trim();
    }

    public static String makeInstallExpirationParam(int daysTillInstallExpire) {
        if (daysTillInstallExpire == 0) {
            return "";
        }
        String daysStr = Integer.toHexString(Math.min(daysTillInstallExpire / 2, 255)).toUpperCase();
        if (daysStr.length() == 1) {
            daysStr = '0' + daysStr;
        }
        long today = System.currentTimeMillis() / MSEC_PER_DAY - DAYS_BEFORE_2002;
        String todayStr = Long.toHexString(today).toUpperCase();
        return "-K" + todayStr + daysStr;
    }

    public static String makeKey(int sum) {
        char ch1 = (char)new Long(Math.round((double)sum * 1.2) % 26L + 65L).byteValue();
        char ch2 = (char)new Long(Math.round((double)sum * 1.4) % 26L + 65L).byteValue();
        char ch3 = (char)new Long(Math.round((double)sum * 1.8) % 26L + 65L).byteValue();
        return "-" + ch1 + ch2 + ch3;
    }

    public static String makeKeyCodeExpirationParam(int daysTillKeyCodeExpire) {
        if (daysTillKeyCodeExpire == 0) {
            return "";
        }
        String daysStr = Integer.toHexString(Math.min(daysTillKeyCodeExpire, 255)).toUpperCase();
        if (daysStr.length() == 1) {
            daysStr = '0' + daysStr;
        }
        long today = System.currentTimeMillis() / MSEC_PER_DAY - DAYS_BEFORE_2002;
        String todayStr = Long.toHexString(today).toUpperCase();
        return "-X" + todayStr + daysStr;
    }

    public static String makeSameComputerParam(String computerID) {
        if (computerID.length() == 0) {
            return "";
        }
        return "-M" + computerID.toUpperCase().replace('O', '0');
    }

    public static String sanitizeName(String name) {
        String str = name.toUpperCase();
        String newStr = "";
        int len = str.length();
        int i2 = 0;
        while (i2 < len) {
            char ch = str.charAt(i2);
            if (ch >= 'A' && ch <= 'Z') {
                newStr = newStr + ch;
            }
            ++i2;
        }
        return newStr;
    }
}

