/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.swing.JCheckBox;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pyware.iPasToolkit.AmaSequence;
import pyware.iPasToolkit.MidiPlayerEvent;
import pyware.iPasToolkit.MidiPlayerListener;
import pyware.iPasToolkit.WaveSyncPlayer;
import pyware.iPasToolkit.WaveSyncPlayerEvent;
import pyware.iPasToolkit.WaveSyncPlayerListener;

public class MidiPlayer {
    public static int STATE_CLOSED = 0;
    public static int STATE_OPENED = 1;
    public static int STATE_STARTED = 2;
    public static int STATE_STOPPED = 3;
    public static int STATE_FINISHED = 4;
    private Sequencer _$3091;
    private String[] _$3665;
    private int _$490 = -1;
    private String _$3666 = "";
    private String _$3667 = "";
    private Vector _$738 = new Vector();
    private AmaSequence _$3668 = null;
    private boolean _$3669 = false;
    private boolean _$3670 = false;
    private boolean _$3671 = false;
    private int _$3672 = 64;
    private double _$3673 = 0.0;
    private WaveSyncPlayer _$3674 = new WaveSyncPlayer();
    private boolean _$3675 = true;

    public MidiPlayer(String paramFilePath) throws Exception {
        this._$3091 = MidiSystem.getSequencer();
        this._$3677(paramFilePath);
        this._$3091.addMetaEventListener(new MetaEventListener(){

            public void meta(MetaMessage meta) {
                MidiPlayer.this._$3679(meta);
            }
        });
        this._$3674.addListener(new WaveSyncPlayerListener(){

            public void error(WaveSyncPlayerEvent e) {
                MidiPlayer.this._$2053("WaveSyncPlayer Error\n" + e.getError());
            }

            public void stateChanged(WaveSyncPlayerEvent e) {
                MidiPlayer.this._$740(e.getState());
            }
        });
    }

    public AmaSequence createAmaSequence(String fileName, int layout) throws Exception {
        return new AmaSequence(this, fileName, layout);
    }

    public AmaSequence createAmaSequence(Sequence sequence) {
        return new AmaSequence(this, sequence);
    }

    public void setWaveSyncFile(String fileName) throws Exception {
        try {
            this._$3674.setFileName(fileName);
        }
        catch (Exception ex) {
            this._$2053("Error loading WaveSync file.\n" + ex.getMessage());
            throw ex;
        }
    }

    private void _$3677(String paramFilePath) throws Exception {
        String str;
        URL url = new URL("file:" + paramFilePath);
        InputStream stream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        this._$3665 = new String[129];
        this._$3665[0] = "Undefined";
        int i2 = 1;
        while ((str = reader.readLine()) != null && i2 < 129) {
            this._$3665[i2++] = str.substring(4);
        }
        stream.close();
    }

    private void _$3679(MetaMessage meta) {
        int type = meta.getType();
        byte[] data = meta.getData();
        if (type == 47 && this.isPlaying() && !this._$3091.isRunning()) {
            this._$739(STATE_FINISHED);
        }
        if (type == 88) {
            byte numerator = data[0];
            int denomonator = data[1] ^ 2;
        }
        if (type == 3) {
            this._$3666 = new String(data);
        }
        if (type == 4) {
            this._$3667 = new String(data);
        }
    }

    private void _$739(int state) {
        this._$490 = state;
        this._$740(state);
    }

    public boolean canUseWaveSyncPlayer() {
        return this._$3675 && this._$3674.getFileName() != null;
    }

    public boolean usingWaveSyncPlayer() {
        return this.canUseWaveSyncPlayer() && !this._$3669 && !this._$3671 && this._$3670;
    }

    private synchronized void _$3693() {
        int i2;
        if (this._$3668 == null) {
            return;
        }
        boolean playMidiAccompany = this._$3670;
        if (this.usingWaveSyncPlayer()) {
            playMidiAccompany = false;
        }
        int len = this._$3668.getNumTracks();
        boolean[] enabledTracks = new boolean[len];
        for (i2 = 0; i2 < len; ++i2) {
            int type = this._$3668.getTrackType(i2);
            if (type == AmaSequence.TRACK_CONDUCTOR) {
                enabledTracks[i2] = true;
                continue;
            }
            if (type == AmaSequence.TRACK_UNUSED_SOLO) {
                enabledTracks[i2] = false;
                continue;
            }
            if (type == AmaSequence.TRACK_ACCOMPANY) {
                enabledTracks[i2] = playMidiAccompany;
                continue;
            }
            if (type == AmaSequence.TRACK_BENCHMARK) {
                enabledTracks[i2] = this._$3669;
                continue;
            }
            if (type != AmaSequence.TRACK_CLICK) continue;
            enabledTracks[i2] = this._$3671;
        }
        for (i2 = 0; i2 < enabledTracks.length; ++i2) {
            this._$3091.setTrackMute(i2, !enabledTracks[i2]);
        }
    }

    private synchronized void _$3703() {
        if (this._$3674.isPlaying()) {
            this._$3674.setVolume(this._$3672);
            return;
        }
        Synthesizer synthesizer = (Synthesizer)((Object)this._$3091);
        MidiChannel[] channels = synthesizer.getChannels();
        for (int i2 = 0; i2 < channels.length; ++i2) {
            channels[i2].controlChange(7, this._$3672);
            if (channels[i2].getController(7) == this._$3672) continue;
            channels[i2].setChannelPressure(this._$3672);
        }
    }

    public void open() {
        if (this._$3091.isOpen()) {
            return;
        }
        try {
            this._$3091.open();
            this._$739(STATE_OPENED);
        }
        catch (Exception e) {
            this._$2053("Unable to open MIDI Player.");
            e.printStackTrace();
        }
    }

    public void close() {
        this._$3091.close();
        this._$739(STATE_CLOSED);
    }

    public void play() {
        if (this._$3091.isRunning()) {
            this._$3091.stop();
        }
        if (this._$3674.isPlaying()) {
            this._$3674.stop();
        }
        this._$3091.setTickPosition(0L);
        if (this.usingWaveSyncPlayer()) {
            this._$3674.start();
        } else {
            this._$3091.start();
        }
        this._$3693();
        this._$3703();
        this._$739(STATE_STARTED);
    }

    public void stop() {
        if (this._$3091.isRunning()) {
            this._$3091.stop();
        }
        if (this._$3674.isPlaying()) {
            this._$3674.stop();
        }
        this._$739(STATE_STOPPED);
    }

    public void finish() {
        if (this._$3091.isRunning()) {
            this._$3091.stop();
        }
        if (this._$3674.isPlaying()) {
            this._$3674.stop();
        }
        this._$739(STATE_FINISHED);
    }

    public int getState() {
        return this._$490;
    }

    public boolean isPlaying() {
        if (this._$3674.isPlaying()) {
            return true;
        }
        return this._$490 == STATE_STARTED;
    }

    public boolean isWaveSyncPlaying() {
        return this._$3674 == null ? false : this._$3674.isPlaying();
    }

    public long getTickPosition() {
        if (this.isWaveSyncPlaying()) {
            return this._$3674.getTickPosition();
        }
        if (this.isPlaying()) {
            return this._$3091.getTickPosition();
        }
        return 0L;
    }

    private void _$3711() {
        if (this._$3668 == null) {
            return;
        }
        double ticksPerBeat = this._$3668.getSequence().getResolution();
        float beatsPerMinute = this._$3715();
        double ticksPerMinute = (double)beatsPerMinute * ticksPerBeat;
        double ticksPerSec = ticksPerMinute / 60.0;
        this._$3673 = ticksPerSec / 1000.0;
    }

    private float _$3715() {
        return this._$3091.getTempoInBPM() * this._$3091.getTempoFactor();
    }

    public void loadPlayer(AmaSequence sequence) {
        try {
            this._$3668 = sequence;
            this._$3091.setSequence(sequence.getSequence());
            this._$3091.setTempoFactor(sequence.getTempoFactor());
            this._$3693();
            this._$3711();
            this.setWaveSyncFile(sequence.getWaveSyncFile());
        }
        catch (Exception e) {
            this._$2053("Unable to load MIDI Player.\nError:" + e.getMessage());
            e.printStackTrace();
        }
        this._$3720(this._$3091);
    }

    public Sequencer getSequencer() {
        return this._$3091;
    }

    public AmaSequence getSequence() {
        return this._$3668;
    }

    public double getTicksPerMSec() {
        return this._$3673;
    }

    public void setTempoFactor(float tempoFactor) {
        this._$3091.setTempoFactor(tempoFactor);
        this._$3711();
    }

    public String getGeneralMidiName(int program) {
        if (program < 0 | program >= this._$3665.length) {
            return null;
        }
        return this._$3665[program];
    }

    public void setTrackEnabled(int trackType, boolean enabled) {
        boolean wasPlayAccompany = this._$3670;
        if (trackType == AmaSequence.TRACK_ACCOMPANY) {
            this._$3670 = enabled;
        }
        if (trackType == AmaSequence.TRACK_CLICK) {
            this._$3671 = enabled;
        }
        if (trackType == AmaSequence.TRACK_BENCHMARK) {
            this._$3669 = enabled;
        }
        this._$3693();
        if (this.isPlaying() && this.canUseWaveSyncPlayer() && this._$3670 != wasPlayAccompany) {
            this._$3729();
        }
    }

    public boolean isTrackEnabled(int trackType) {
        if (trackType == AmaSequence.TRACK_ACCOMPANY) {
            return this._$3670;
        }
        if (trackType == AmaSequence.TRACK_CLICK) {
            return this._$3671;
        }
        if (trackType == AmaSequence.TRACK_BENCHMARK) {
            return this._$3669;
        }
        return trackType == AmaSequence.TRACK_CONDUCTOR;
    }

    public void setVolume(int volume) {
        this._$3672 = volume;
        this._$3703();
    }

    public ActionListener getControlListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().toUpperCase().startsWith("BENCHMARK")) {
                    MidiPlayer.this.setTrackEnabled(AmaSequence.TRACK_BENCHMARK, ((JCheckBox)e.getSource()).isSelected());
                }
                if (e.getActionCommand().toUpperCase().startsWith("ACCOMPANIMENT")) {
                    MidiPlayer.this.setTrackEnabled(AmaSequence.TRACK_ACCOMPANY, ((JCheckBox)e.getSource()).isSelected());
                }
                if (e.getActionCommand().toUpperCase().startsWith("CLICKS")) {
                    MidiPlayer.this.setTrackEnabled(AmaSequence.TRACK_CLICK, ((JCheckBox)e.getSource()).isSelected());
                }
            }
        };
    }

    public ChangeListener getVolumeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MidiPlayer.this.setVolume(((JSlider)e.getSource()).getValue());
            }
        };
    }

    public boolean setSoundBand(String filePath) {
        try {
            File file = new File(filePath);
            MidiSystem.getSoundbank(file);
        }
        catch (IOException ex) {
            return false;
        }
        catch (InvalidMidiDataException ex) {
            return false;
        }
        return true;
    }

    private void _$2053(String msg) {
        MidiPlayerEvent e = MidiPlayerEvent.createErrorEvent(this, msg);
        for (int i2 = 0; i2 < this._$738.size(); ++i2) {
            ((MidiPlayerListener)this._$738.elementAt(i2)).error(e);
        }
    }

    private void _$740(int state) {
        MidiPlayerEvent e = MidiPlayerEvent.createStateChangedEvent(this, state);
        for (int i2 = 0; i2 < this._$738.size(); ++i2) {
            ((MidiPlayerListener)this._$738.elementAt(i2)).stateChanged(e);
        }
    }

    private void _$3729() {
        MidiPlayerEvent e = MidiPlayerEvent.createRestartNeededEvent(this);
        for (int i2 = 0; i2 < this._$738.size(); ++i2) {
            ((MidiPlayerListener)this._$738.elementAt(i2)).restartNeeded(e);
        }
    }

    private void _$3720(Sequencer sequencer) {
        MidiPlayerEvent e = MidiPlayerEvent.createPlayerLoadedEvent(this, sequencer);
        for (int i2 = 0; i2 < this._$738.size(); ++i2) {
            ((MidiPlayerListener)this._$738.elementAt(i2)).playerLoaded(e);
        }
    }

    public synchronized void addListener(MidiPlayerListener listener) {
        this._$738.addElement(listener);
    }

    public synchronized void removeListener(MidiPlayerListener listener) {
        this._$738.removeElement(listener);
    }
}

