/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit;

import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import pyware.iPasToolkit.TrackExtents;

public class MidiUtils {
    public static int getMidiCommand(MidiEvent event) {
        if (!ShortMessage.class.isInstance(event.getMessage())) {
            return -1;
        }
        ShortMessage msg = (ShortMessage)event.getMessage();
        return msg.getCommand();
    }

    public static boolean isMidiCommand(MidiEvent event, int shortMessageCommand) {
        int command = MidiUtils.getMidiCommand(event);
        if (command == -1) {
            return false;
        }
        return command == shortMessageCommand;
    }

    public static int getData1(MidiEvent event) {
        if (!ShortMessage.class.isInstance(event.getMessage())) {
            return -1;
        }
        ShortMessage msg = (ShortMessage)event.getMessage();
        return msg.getData1();
    }

    public static int getData2(MidiEvent event) {
        if (!ShortMessage.class.isInstance(event.getMessage())) {
            return -1;
        }
        ShortMessage msg = (ShortMessage)event.getMessage();
        return msg.getData2();
    }

    public static boolean isNoteOn(MidiEvent event) {
        if (event == null) {
            return false;
        }
        return MidiUtils.isMidiCommand(event, 144) && MidiUtils.getData2(event) > 0;
    }

    public static boolean isNoteOff(MidiEvent event) {
        if (event == null) {
            return false;
        }
        if (MidiUtils.isMidiCommand(event, 144) && MidiUtils.getData2(event) == 0) {
            return true;
        }
        return MidiUtils.isMidiCommand(event, 128);
    }

    public static double pitchBendToCents(MidiEvent event) {
        if (!MidiUtils.isMidiCommand(event, 224)) {
            return 0.0;
        }
        MidiMessage msg = event.getMessage();
        byte[] data = msg.getMessage();
        int val = data[1] + data[2] * 128 - 8192;
        return (double)val / 8192.0;
    }

    public static MidiEvent findNextNoteOff(Track track, MidiEvent noteOn) {
        if (!MidiUtils.isNoteOn(noteOn)) {
            return null;
        }
        int noteOnIndex = MidiUtils.midiTrackIndexOf(track, noteOn);
        for (int i2 = noteOnIndex + 1; i2 < track.size(); ++i2) {
            if (!MidiUtils.isNoteOff(track.get(i2))) continue;
            return track.get(i2);
        }
        return null;
    }

    public static MidiEvent findNoteOnAt(Track track, long timestamp) {
        if (track == null) {
            return null;
        }
        MidiEvent lastNoteOn = null;
        int len = track.size();
        for (int i2 = 0; i2 < len; ++i2) {
            MidiEvent event = track.get(i2);
            if (event.getTick() >= timestamp) {
                i2 = track.size();
                continue;
            }
            if (MidiUtils.isNoteOn(event)) {
                lastNoteOn = event;
                continue;
            }
            if (!MidiUtils.isNoteOff(event)) continue;
            lastNoteOn = null;
        }
        return lastNoteOn;
    }

    public static int midiTrackIndexOf(Track track, MidiEvent event) {
        for (int i2 = 0; i2 < track.size(); ++i2) {
            if (!track.get(i2).equals(event)) continue;
            return i2;
        }
        return -1;
    }

    public static void dumpTrack(Track track, String msg) {
        System.out.println("Track NoteOn/Off Dump");
        if (msg != null && msg.length() > 0) {
            System.out.println(msg);
        }
        System.out.println("Index\tNote#\tMIDI#\tNoteOn\tNoteOff");
        int count = 0;
        for (int i2 = 0; i2 < track.size(); ++i2) {
            MidiEvent e = track.get(i2);
            if (MidiUtils.isNoteOn(e)) {
                System.out.print(i2 + "\t" + count++ + "\t" + MidiUtils.getData1(e) + "\t" + e.getTick() + "\t");
            }
            if (!MidiUtils.isNoteOff(e)) continue;
            System.out.print(e.getTick() + "\n");
        }
    }

    public static int mSecToTicks(Sequencer sequencer, long mSec) {
        float tempo = sequencer.getTempoInBPM() * sequencer.getTempoFactor();
        int resolution = sequencer.getSequence().getResolution();
        float divisionType = sequencer.getSequence().getDivisionType();
        return MidiUtils.mSecToTicks(tempo, resolution, divisionType, mSec);
    }

    public static int mSecToTicks(float tempo, int resolution, float divisionType, long mSec) {
        float fTicks = 0.0f;
        if (divisionType == 0.0f) {
            float beatsPerMsec = tempo / 60.0f / 1000.0f;
            float ticksPerBeat = resolution;
            float beats = (float)mSec * beatsPerMsec;
            fTicks = beats * ticksPerBeat;
        }
        return new Float(fTicks).intValue();
    }

    public static TrackExtents getTrackExtents(Track track) {
        int minNoteNum = 128;
        int maxNoteNum = 0;
        for (int i2 = 0; i2 < track.size(); ++i2) {
            MidiEvent e = track.get(i2);
            if (!MidiUtils.isNoteOn(e)) continue;
            int noteNum = MidiUtils.getData1(e);
            minNoteNum = Math.min(noteNum, minNoteNum);
            maxNoteNum = Math.max(noteNum, maxNoteNum);
        }
        return new TrackExtents(minNoteNum, maxNoteNum);
    }
}

