/*
 * Decompiled with CFR 0.152.
 */
package pyware.iPasToolkit;

import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import pyware.iPasToolkit.WaveSyncPlayerEvent;
import pyware.iPasToolkit.WaveSyncPlayerListener;
import pyware.toolkit.FileUtils;

public class WaveSyncPlayer
implements Runnable {
    public static int LATENCY = 280;
    private static int _$2013 = 1028;
    public static int STARTING = 1;
    public static int PLAYING = 2;
    public static int STOPPED = 3;
    public static int FINISHED = 4;
    private int _$490 = STOPPED;
    private Thread _$2018;
    private String _$2019 = null;
    private AudioInputStream _$2020;
    private SourceDataLine _$2021;
    private byte[] _$2022;
    private Vector _$738 = new Vector();
    private BitSet _$1134 = null;
    private double _$2023;
    private long _$2024 = 0L;
    private int _$2025 = 0;
    private int _$2026 = 0;
    private int _$2027 = 0;
    private int _$2028 = 0;
    private BitSet _$2029 = null;
    private byte[] _$2030;

    private void _$739(int state) {
        this._$490 = state;
        this._$740(state);
    }

    private boolean _$2031() {
        return this._$2020 != null;
    }

    private void _$2032() throws Exception {
        int i2;
        int bytesRead;
        long size = this._$2020.getFrameLength();
        this._$1134 = new BitSet(new Long(size).intValue());
        this._$2029 = new BitSet(new Long(size).intValue());
        Vector<Byte> vQueValue = new Vector<Byte>();
        int frameCount = 0;
        while ((bytesRead = this._$2020.read(this._$2022, 0, this._$2022.length)) != -1) {
            for (i2 = 1; i2 < bytesRead; i2 += 2) {
                if (this._$2022[i2] == 1) {
                    this._$1134.set(frameCount, true);
                }
                if (this._$2022[i2] > 1) {
                    this._$2029.set(frameCount, true);
                    vQueValue.add(new Byte(this._$2022[i2]));
                }
                ++frameCount;
            }
        }
        this._$2030 = new byte[vQueValue.size()];
        for (i2 = 0; i2 < this._$2030.length; ++i2) {
            this._$2030[i2] = (Byte)vQueValue.elementAt(i2);
        }
    }

    private AudioFormat _$2038(String fileName) throws Exception {
        File soundFile = new File(fileName);
        this._$2020 = AudioSystem.getAudioInputStream(soundFile);
        long size = this._$2020.getFrameLength();
        if (size > Integer.MAX_VALUE) {
            throw new Exception("The Wave Sync file is too big for the WaveSyncPlayer to handle.");
        }
        AudioFormat audioFormat = this._$2020.getFormat();
        if (audioFormat.getChannels() != 2 | audioFormat.getSampleSizeInBits() != 8) {
            throw new Exception("The Wave Sync file is not in the correct format (8 bit, 2 channel).");
        }
        this._$2023 = (double)audioFormat.getSampleRate() / 1000.0;
        this._$2032();
        this._$2020.close();
        this._$2020 = AudioSystem.getAudioInputStream(soundFile);
        return audioFormat;
    }

    private void _$2047() throws Exception {
        if (this._$2031()) {
            return;
        }
        this._$2022 = new byte[_$2013];
        AudioFormat audioFormat = this._$2038(this._$2019);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        this._$2021 = (SourceDataLine)AudioSystem.getLine(info);
        this._$2021.open(audioFormat);
        this._$2021.start();
    }

    private void _$2046() {
        if (!this._$2031()) {
            return;
        }
        try {
            this._$2020.close();
        }
        catch (IOException ex) {
            this._$2053(ex.getMessage());
        }
        this._$2020 = null;
        this._$2021.close();
        this._$2021 = null;
    }

    private int _$2054(double time) {
        return new Double(time * this._$2023).intValue();
    }

    private long _$2055(int index) {
        return new Double((double)index / this._$2023).longValue();
    }

    public void run() {
        this._$739(STARTING);
        int bytesRead = 0;
        try {
            this._$2047();
            this._$2025 = 0;
            this._$2026 = 0;
            this._$2027 = 0;
            this._$2028 = 0;
            this._$2024 = System.currentTimeMillis();
            this._$739(PLAYING);
            while (this._$2018 != null) {
                bytesRead = this._$2020.read(this._$2022, 0, this._$2022.length);
                if (bytesRead != -1) {
                    byte[] audioBuf = new byte[bytesRead];
                    for (int i2 = 0; i2 < bytesRead; i2 += 2) {
                        audioBuf[i2] = this._$2022[i2];
                        audioBuf[i2 + 1] = this._$2022[i2];
                    }
                    int bytesWritten = this._$2021.write(audioBuf, 0, audioBuf.length);
                    this._$2062();
                }
                if (bytesRead != -1) continue;
                this._$2021.drain();
                this._$2018 = null;
            }
        }
        catch (Exception ex) {
            this._$2053(ex.getMessage());
        }
        if (bytesRead != -1) {
            this._$2021.flush();
        }
        this._$2046();
        if (bytesRead == -1) {
            this._$739(FINISHED);
        } else {
            this._$739(STOPPED);
        }
    }

    private void _$2062() {
        if (this._$2030.length == 0) {
            return;
        }
        long time = System.currentTimeMillis() - this._$2024;
        int index = Math.min(this._$2054(time) + 1, this._$1134.length());
        for (int i2 = this._$2027 + 1; i2 < index; ++i2) {
            if (!this._$2029.get(i2)) continue;
            this._$2066(this._$2055(i2), this._$2030[this._$2028++]);
        }
        this._$2027 = index;
    }

    private int _$2067(double time) {
        int index = Math.min(this._$2054(time) + 1, this._$1134.length());
        for (int i2 = this._$2026 + 1; i2 < index; ++i2) {
            if (!this._$1134.get(i2)) continue;
            ++this._$2025;
        }
        this._$2026 = index;
        return this._$2025;
    }

    public long getTickPosition() {
        return this._$2067(System.currentTimeMillis() - this._$2024);
    }

    public boolean isPlaying() {
        return this._$490 == PLAYING && this._$2018 != null;
    }

    public synchronized void start() {
        if (this._$2018 != null) {
            this.stop();
        }
        this._$2018 = new Thread(this);
        this._$2018.setName("WaveSyncPlayer");
        this._$2018.start();
    }

    public synchronized void stop() {
        this._$2018 = null;
    }

    public synchronized void setFileName(String fileName) throws Exception {
        if (fileName == null) {
            this._$2019 = null;
            return;
        }
        if (!FileUtils.hasSuffix(fileName, "wvs")) {
            fileName = FileUtils.appendSuffix(fileName, "wvs");
        }
        this._$2019 = fileName;
    }

    public String getFileName() {
        return this._$2019;
    }

    public int getTotalBeats() {
        if (this._$1134 == null) {
            return 0;
        }
        int len = this._$1134.length();
        int count = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!this._$1134.get(i2)) continue;
            ++count;
        }
        return count;
    }

    public void setVolume(int percent) {
        SourceDataLine line = this._$2021;
        if (line == null) {
            return;
        }
        FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
        if (gainControl != null) {
            float value = (float)percent / 100.0f;
            float dB = (float)(Math.log((double)value == 0.0 ? 1.0E-4 : (double)value) / Math.log(10.0) * 20.0);
            gainControl.setValue(dB);
        }
    }

    private void _$2053(String msg) {
        WaveSyncPlayerEvent e = WaveSyncPlayerEvent.createErrorEvent(this, msg);
        for (int i2 = 0; i2 < this._$738.size(); ++i2) {
            ((WaveSyncPlayerListener)this._$738.elementAt(i2)).error(e);
        }
    }

    private void _$740(int state) {
        WaveSyncPlayerEvent e = WaveSyncPlayerEvent.createStateChangedEvent(this, state);
        for (int i2 = 0; i2 < this._$738.size(); ++i2) {
            ((WaveSyncPlayerListener)this._$738.elementAt(i2)).stateChanged(e);
        }
    }

    private void _$2066(long time, byte value) {
        WaveSyncPlayerEvent e = WaveSyncPlayerEvent.createStateChangedEvent(this, this._$490);
        for (int i2 = 0; i2 < this._$738.size(); ++i2) {
            ((WaveSyncPlayerListener)this._$738.elementAt(i2)).que(e);
        }
    }

    public synchronized void addListener(WaveSyncPlayerListener listener) {
        this._$738.addElement(listener);
    }

    public synchronized void removeListener(WaveSyncPlayerListener listener) {
        this._$738.removeElement(listener);
    }
}

