/*
 * Decompiled with CFR 0.152.
 */
package pyware.pyMusicTools;

import java.util.Vector;

public class MusicConstants {
    public static int CLEF_TREBLE = 0;
    public static int CLEF_ALTO = 1;
    public static int CLEF_TENOR = 2;
    public static int CLEF_BASS = 3;
    public static int TOTAL_CLEFS = 4;
    private static String _$670 = "Treble,Alto..,Tenor.,Bass..,";
    public static int KEY_C = 0;
    public static int KEY_CSharp = 1;
    public static int KEY_Db = 2;
    public static int KEY_D = 3;
    public static int KEY_Eb = 4;
    public static int KEY_E = 5;
    public static int KEY_F = 6;
    public static int KEY_FSharp = 7;
    public static int KEY_Gb = 8;
    public static int KEY_G = 9;
    public static int KEY_Ab = 10;
    public static int KEY_A = 11;
    public static int KEY_Bb = 12;
    public static int KEY_B = 13;
    public static int KEY_Cb = 14;
    public static int KEY_SolFeg = 15;
    public static int TOTAL_KEYS = 16;
    private static String _$688 = "C.,C#,Db,D.,Eb,E.,F.,F#,Gb,G.,Ab,A.,Bb,B.,Cb,So,";
    public static int BIAS_SHARP = 0;
    public static int BIAS_FLAT = 1;
    public static int BIAS_NEUTRAL = 2;
    public static int TOTAL_BIAS_TYPES = 3;

    public static int parseClefString(String clefStr) {
        clefStr = clefStr.toUpperCase();
        for (int i2 = clefStr.length(); i2 < 6; ++i2) {
            clefStr = clefStr + '.';
        }
        clefStr = clefStr + ',';
        int pos = _$670.toUpperCase().indexOf(clefStr);
        if (pos == -1) {
            return 0;
        }
        return pos / 7;
    }

    public static String toClefString(int clef) {
        int pos = clef * 7;
        return _$670.substring(pos, pos + 6).replace('.', ' ').trim();
    }

    public static Vector getClefList() {
        Vector<String> list = new Vector<String>();
        for (int i2 = 0; i2 < TOTAL_CLEFS; ++i2) {
            list.addElement(MusicConstants.toClefString(i2));
        }
        return list;
    }

    public static int parseKeyString(String keyStr) {
        if ((keyStr = keyStr.substring(0, 2).toUpperCase()).length() == 1) {
            keyStr = keyStr + '.';
        }
        keyStr = keyStr + ',';
        int pos = _$688.toUpperCase().indexOf(keyStr);
        if (pos == -1) {
            return 0;
        }
        return pos / 3;
    }

    public static int parseBiasString(String bias) {
        if (bias.toUpperCase().startsWith("FLAT")) {
            return BIAS_FLAT;
        }
        return BIAS_SHARP;
    }

    public String toBiasString(int bias) {
        if (bias == BIAS_FLAT) {
            return "Flat";
        }
        if (bias == BIAS_SHARP) {
            return "Sharp";
        }
        return "";
    }
}

