/*
 * Decompiled with CFR 0.152.
 */
package pyware.toolkit;

import pyware.toolkit.ParameterDecoder;

public class Decoder
extends ParameterDecoder {
    public String decode(String data) {
        if (data.startsWith("*")) {
            return this.decode(data.substring(1).getBytes());
        }
        return data;
    }

    public String decode(byte[] data) {
        long seed = data[0] - 30;
        long seedInc = data[1] - 30;
        StringBuffer buf = new StringBuffer();
        for (int i2 = 2; i2 < data.length; i2 += 2) {
            long mult = (long)(data[i2] - 32) * seed;
            long remainder = data[i2 + 1] - 33;
            buf.append((char)new Long(mult + remainder).byteValue());
            seed = (seed + seedInc) % 14L + 2L;
        }
        return buf.toString();
    }

    public byte[] encode(byte[] data) {
        long seed = Math.round(Math.random() * 30.0) + 2L;
        long seedInc = Math.round(Math.random() * 8.0) + 2L;
        StringBuffer buf = new StringBuffer();
        char ch1 = (char)new Long(seed + 30L).byteValue();
        char ch2 = (char)new Long(seedInc + 30L).byteValue();
        buf.append(ch1);
        buf.append(ch2);
        for (int i2 = 0; i2 < data.length; ++i2) {
            ch1 = (char)new Long((long)data[i2] / seed + 32L).byteValue();
            long val = (long)data[i2] % seed;
            ch2 = (char)new Long(val + 33L).byteValue();
            seed = (seed + seedInc) % 14L + 2L;
            buf.append(ch1);
            buf.append(ch2);
        }
        return buf.toString().getBytes();
    }

    public String encodeStr(String data) {
        return "*" + new String(this.encode(data));
    }
}

