/*
 * Decompiled with CFR 0.152.
 */
package pyware.toolkit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Vector;
import pyware.toolkit.Decoder;

public class IniFile {
    private Vector _$3708 = new Vector();
    private URL _$1239;
    private boolean _$3709 = false;

    public IniFile() {
    }

    public IniFile(IniFile aIniFile) throws MalformedURLException {
        this.copyFrom(aIniFile);
    }

    public IniFile(URL location) {
        try {
            this.setURL(location);
            this._$3714();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IniFile(String filePath) {
        try {
            this.setURL(new URL("file:" + filePath));
            this._$3714();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyFrom(IniFile iniFile) throws MalformedURLException {
        this._$3708.removeAllElements();
        this._$3708.addAll(iniFile._$3708);
        URL aURL = iniFile._$1239;
        this._$1239 = new URL(aURL.getProtocol(), aURL.getHost(), aURL.getFile());
    }

    private synchronized void _$3714() throws IOException {
        String str;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this._$1239.openStream()));
        this._$3708.removeAllElements();
        while ((str = reader.readLine()) != null) {
            this._$3708.addElement(str);
        }
        this._$3709 = false;
        reader.close();
    }

    private synchronized void _$3721() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this._$1239.getPath()));
        this._$3723();
        int num = this._$3708.size();
        for (int i2 = 0; i2 < num; ++i2) {
            writer.write(this._$3725(i2));
            writer.newLine();
        }
        writer.close();
        this._$3709 = false;
    }

    private String _$3727(String value) {
        StringBuffer oldBuffer = new StringBuffer(value);
        StringBuffer newBuffer = new StringBuffer();
        for (int i2 = 0; i2 < oldBuffer.length(); ++i2) {
            char chVal = oldBuffer.charAt(i2);
            String val = Integer.toHexString(chVal + (i2 + 5) % 10);
            while (val.length() < 3) {
                val = "0" + val;
            }
            newBuffer.append(val);
        }
        return newBuffer.toString();
    }

    private String _$3732(String text) {
        StringBuffer result = new StringBuffer();
        int len = text.length();
        for (int i2 = 0; i2 < len; i2 += 3) {
            int offset = (i2 / 3 + 5) % 10;
            String val = "" + text.charAt(i2) + text.charAt(i2 + 1) + text.charAt(i2 + 2);
            int intVal = Integer.parseInt(val, 16) - offset;
            char ch = (char)intVal;
            result.append(ch);
        }
        return result.toString();
    }

    public String getEncodedLine(String section, String key, String defValue) {
        String str = this.getLine(section, key, null);
        return str == null ? defValue : this._$3732(str);
    }

    public void setEncodedLine(String section, String key, String value) {
        this.setLine(section, key, this._$3727(value));
    }

    private void _$3723() {
        boolean thisLineBlank = false;
        boolean previousLineBlank = false;
        for (int i2 = this._$3708.size() - 1; i2 >= 0; --i2) {
            boolean bl2 = thisLineBlank = this._$3725(i2).trim().length() == 0;
            if (previousLineBlank && thisLineBlank) {
                this._$3708.removeElementAt(i2 + 1);
                this._$3709 = true;
            }
            previousLineBlank = thisLineBlank;
        }
        if (this._$3708.size() > 0 && this._$3725(0).length() == 0) {
            this._$3708.removeElementAt(0);
        }
    }

    private String _$3725(int index) {
        return (String)this._$3708.elementAt(index);
    }

    private int _$3741(String key, int startIndex, int stopIndex) {
        key = this._$3744(key).toLowerCase();
        if (startIndex != -1 && stopIndex != -1) {
            for (int i2 = startIndex; i2 <= stopIndex; ++i2) {
                if (!this._$3725(i2).toLowerCase().startsWith(key)) continue;
                return i2;
            }
        }
        return -1;
    }

    private int _$3741(String section, String key) {
        int startIndex = this._$3746(section);
        int stopIndex = this._$3747(startIndex);
        return this._$3741(key, startIndex, stopIndex);
    }

    private String _$3744(String key) {
        if (!(key = key.trim()).endsWith("=")) {
            key = key + "=";
        }
        return key;
    }

    private String _$3748(String section) {
        if (!(section = section.trim()).startsWith("[")) {
            section = "[" + section;
        }
        if (!section.endsWith("]")) {
            section = section + "]";
        }
        return section;
    }

    private int _$3746(String section) {
        section = this._$3748(section).toLowerCase();
        for (int i2 = 0; i2 < this._$3708.size(); ++i2) {
            if (!this._$3725(i2).toLowerCase().startsWith(section)) continue;
            return i2;
        }
        return -1;
    }

    private int _$3749(String section) {
        this._$3708.addElement("");
        this._$3708.addElement(this._$3748(section));
        int index = this._$3708.size() - 1;
        return index;
    }

    private int _$3747(int index) {
        if (index == -1) {
            return -1;
        }
        for (int i2 = index + 1; i2 < this._$3708.size(); ++i2) {
            if (!this._$3725(i2).toLowerCase().startsWith("[")) continue;
            return i2;
        }
        return this._$3708.size() - 1;
    }

    private Color _$3751(String str) {
        int start = 0;
        int colorIndex = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        str = str + ",";
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (str.charAt(i2) != ',') continue;
            String smStr = str.substring(start, i2);
            start = i2 + 1;
            try {
                if (colorIndex == 0) {
                    red = new Integer(smStr);
                }
                if (colorIndex == 1) {
                    green = new Integer(smStr);
                }
                if (colorIndex == 2) {
                    blue = new Integer(smStr);
                }
                ++colorIndex;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return new Color(red, green, blue);
    }

    private String _$3756(Color aColor) {
        return new Integer(aColor.getRed()).toString() + "," + new Integer(aColor.getGreen()).toString() + "," + new Integer(aColor.getBlue()).toString();
    }

    private Point _$3761(String str) {
        if (str == null) {
            return null;
        }
        int start = 0;
        int pointIndex = 0;
        int x2 = 0;
        int y2 = 0;
        str = str + ",";
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (str.charAt(i2) != ',') continue;
            String smStr = str.substring(start, i2);
            start = i2 + 1;
            try {
                if (pointIndex == 0) {
                    x2 = new Integer(smStr);
                }
                if (pointIndex == 1) {
                    y2 = new Integer(smStr);
                }
                ++pointIndex;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return new Point(x2, y2);
    }

    private String _$3764(Point aPoint) {
        if (aPoint == null) {
            return null;
        }
        return aPoint.x + "," + aPoint.y;
    }

    public boolean isChanged() {
        return this._$3709;
    }

    public void setURL(URL url) {
        this._$1239 = url;
        this._$3709 = true;
    }

    public URL getURL() {
        return this._$1239;
    }

    public void load() throws IOException {
        this._$3714();
    }

    public void load(File file) throws IOException {
        this.setURL(new URL("file" + file.getAbsoluteFile()));
        this._$3714();
    }

    public void load(URL url) throws IOException {
        this.setURL(url);
        this._$3714();
    }

    public void load(String filePath) throws IOException {
        this.setURL(new URL("file:" + filePath));
        this._$3714();
    }

    public void save() throws IOException {
        if (this._$3709) {
            this._$3721();
        }
    }

    public void saveAs(String filePath) throws IOException {
        this.setURL(new URL("file:" + filePath));
        this._$3721();
    }

    public void saveACopy(String filePath) throws IOException {
        URL holdURL = this._$1239;
        this.setURL(new URL("file:" + filePath));
        this._$3721();
        this._$1239 = holdURL;
    }

    public void removeSection(String section) {
        int start = this._$3746(section);
        if (start == -1) {
            return;
        }
        int stop = this._$3747(start);
        if (stop == this._$3708.size() - 1 && !this._$3725(stop).startsWith("[")) {
            ++stop;
        }
        for (int i2 = stop - 1; i2 >= start; --i2) {
            this._$3708.removeElementAt(i2);
            this._$3709 = true;
        }
    }

    public void renameSection(String oldSection, String newSection) {
        int index = this._$3746(oldSection);
        if (index == -1) {
            return;
        }
        this._$3708.setElementAt(this._$3748(newSection), index);
        this._$3709 = true;
    }

    public void removeLine(String section, String key) {
        int index = this._$3741(section, key);
        if (index == -1) {
            return;
        }
        this._$3708.removeElementAt(index);
        this._$3709 = true;
    }

    public void removeAll() {
        this._$3708.removeAllElements();
    }

    public String getLine(String section, String key, String defValue) {
        int index = this._$3741(section, key);
        if (index == -1) {
            return defValue;
        }
        String str = this._$3725(index);
        str = str.substring(this._$3744(key).length(), str.length()).trim();
        str = str.replace('\u00fe', '\n');
        str = str.replace('\u00ff', '\r');
        return str;
    }

    public String getLine(String section, String key, String defValue, Decoder decoder) {
        String line = this.getLine(section, key, defValue);
        return line == null ? null : decoder.decode(line);
    }

    public short getShortLine(String section, String key, short defValue) {
        try {
            return new Short(this.getLine(section, key, "err"));
        }
        catch (Exception ex) {
            return defValue;
        }
    }

    public int getIntLine(String section, String key, int defValue) {
        try {
            return new Integer(this.getLine(section, key, "err"));
        }
        catch (Exception ex) {
            return defValue;
        }
    }

    public long getLongLine(String section, String key, long defValue) {
        try {
            return new Long(this.getLine(section, key, "err"));
        }
        catch (Exception ex) {
            return defValue;
        }
    }

    public double getDoubleLine(String section, String key, double defValue) {
        try {
            return new Double(this.getLine(section, key, "err"));
        }
        catch (Exception ex) {
            return defValue;
        }
    }

    public float getFloatLine(String section, String key, float defValue) {
        try {
            return new Float(this.getLine(section, key, "err")).floatValue();
        }
        catch (Exception ex) {
            return defValue;
        }
    }

    public Timestamp getTimeStampLine(String section, String key, Timestamp defValue) {
        Timestamp stamp;
        try {
            long longVal = this.getLongLine(section, key, 0L);
            stamp = longVal == 0L ? defValue : new Timestamp(longVal);
        }
        catch (Exception ex) {
            stamp = defValue;
        }
        return stamp;
    }

    public boolean getBoolLine(String section, String key, boolean defValue) {
        String defStrValue = "false";
        if (defValue) {
            defStrValue = "true";
        }
        String val = this.getLine(section, key, defStrValue).toLowerCase();
        return val.equals("true") | val.equals("yes") | val.equals("1");
    }

    public Color getColorLine(String section, String key, Color defValue) {
        return this._$3751(this.getLine(section, key, this._$3756(defValue)));
    }

    public Point getPointLine(String section, String key, Point defValue) {
        return this._$3761(this.getLine(section, key, this._$3764(defValue)));
    }

    public String[] getStringList(String section, String key) {
        String str = this.getLine(section, key, null);
        if (str == null) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        if (!str.endsWith(";")) {
            str = str + ';';
        }
        int pos1 = 0;
        int pos2 = str.indexOf(59);
        while (pos2 > 0) {
            list.addElement(str.substring(pos1, pos2));
            pos1 = pos2 + 1;
            pos2 = str.indexOf(59, pos1);
        }
        String[] result = new String[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            result[i2] = (String)list.elementAt(i2);
        }
        return result;
    }

    public void setStringList(String section, String key, String[] list) {
        StringBuffer strBuf = new StringBuffer();
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (i2 > 0) {
                strBuf.append(';');
            }
            strBuf.append(list[i2]);
        }
        this.setLine(section, key, strBuf.toString());
    }

    public String getFontName(String section, String key, Font font) {
        String fontName = "";
        if (font != null) {
            fontName = font.getName();
        }
        return this.getLine(section, key + ".name", fontName);
    }

    public int getFontStyle(String section, String key, Font font) {
        int fontStyle = 0;
        if (font != null) {
            fontStyle = font.getStyle();
        }
        return this.getIntLine(section, key + ".style", fontStyle);
    }

    public int getFontSize(String section, String key, Font font) {
        int fontSize = 12;
        if (font != null) {
            fontSize = font.getSize();
        }
        return this.getIntLine(section, key + ".size", fontSize);
    }

    public Font getFontLine(String section, String key, Font font) {
        int fSize;
        int fStyle;
        String fName = this.getFontName(section, key, font);
        Font newFont = new Font(fName, fStyle = this.getFontStyle(section, key, font), fSize = this.getFontSize(section, key, font));
        if (newFont == null) {
            return font;
        }
        return newFont;
    }

    public String[] getSectionList(String section) {
        int start = this._$3746(section);
        if (start == -1) {
            return new String[0];
        }
        int stop = this._$3747(start);
        Vector<String> list = new Vector<String>();
        for (int i2 = start + 1; i2 <= stop; ++i2) {
            String s2 = this._$3725(i2);
            int pos = s2.indexOf(61);
            if (pos != -1) {
                list.add(s2.substring(0, pos));
                continue;
            }
            if (s2.length() <= 0 || s2.startsWith("[")) continue;
            list.add(s2);
        }
        String[] result = new String[list.size()];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            result[i3] = (String)list.elementAt(i3);
        }
        return result;
    }

    public String[] getListOfSections() {
        Vector<String> list = new Vector<String>();
        for (int i2 = 0; i2 < this._$3708.size(); ++i2) {
            String s2 = this._$3725(i2);
            if (!s2.startsWith("[")) continue;
            list.addElement(s2.substring(1, s2.length() - 1));
        }
        String[] stringList = new String[list.size()];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            stringList[i3] = (String)list.elementAt(i3);
        }
        return stringList;
    }

    public void setLine(String section, String key, String value) {
        int startIndex = this._$3746(section);
        if (startIndex == -1) {
            startIndex = this._$3749(section);
        }
        int stopIndex = this._$3747(startIndex);
        int index = this._$3741(key, startIndex, stopIndex);
        value = value.replace('\n', '\u00fe');
        value = value.replace('\r', '\u00ff');
        value = this._$3744(key) + value;
        if (index != -1) {
            this._$3708.setElementAt(value, index);
        } else if (startIndex == this._$3708.size() - 1) {
            this._$3708.addElement(value);
        } else {
            this._$3708.insertElementAt(value, startIndex + 1);
        }
        this._$3709 = true;
    }

    public void setShortLine(String section, String key, short value) {
        this.setLine(section, key, new Short(value).toString());
    }

    public void setIntLine(String section, String key, int value) {
        this.setLine(section, key, new Integer(value).toString());
    }

    public void setLongLine(String section, String key, long value) {
        this.setLine(section, key, new Long(value).toString());
    }

    public void setDoubleLine(String section, String key, double value) {
        this.setLine(section, key, new Double(value).toString());
    }

    public void setFloatLine(String section, String key, float value) {
        this.setLine(section, key, new Float(value).toString());
    }

    public void setTimeStampLine(String section, String key, Timestamp time) {
        this.setLine(section, key, Long.toString(time.getTime()));
    }

    public void setBoolLine(String section, String key, boolean value) {
        if (value) {
            this.setLine(section, key, "true");
        } else {
            this.setLine(section, key, "false");
        }
    }

    public void setColorLine(String section, String key, Color color) {
        this.setLine(section, key, this._$3756(color));
    }

    public void setPointLine(String section, String key, Point point) {
        this.setLine(section, key, this._$3764(point));
    }

    public void setFontLine(String section, String key, Font font) {
        if (font == null) {
            return;
        }
        this.setLine(section, key + ".name", font.getFontName());
        this.setIntLine(section, key + ".style", font.getStyle());
        this.setIntLine(section, key + ".size", font.getSize());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < this._$3708.size(); ++i2) {
            buffer.append((String)this._$3708.elementAt(i2));
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public void setData(String data) {
        if (!data.endsWith("\n")) {
            data = data + '\n';
        }
        this._$3708.removeAllElements();
        int begin = 0;
        for (int end = 0; end < data.length(); ++end) {
            if (data.charAt(end) != '\n') continue;
            String substring = data.substring(begin, end);
            this._$3708.addElement(substring);
            begin = end + 1;
        }
        this._$3709 = true;
    }
}

