/*
 * Decompiled with CFR 0.152.
 */
package pyware.toolkit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.util.Calendar;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class Utils {
    public static boolean isMacintosh() {
        return System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    }

    public static String workingDirPath() {
        return System.getProperty("user.dir", ".");
    }

    public static long byteArrayToLongValue(byte[] byteArray) {
        if (byteArray == null) {
            return 0L;
        }
        int arrayLen = byteArray.length;
        long longVal = 0L;
        for (int i2 = 0; i2 < arrayLen; ++i2) {
            int byteVal = byteArray[i2] & 0xFF;
            longVal = (longVal << 8) + (long)byteVal;
        }
        return longVal;
    }

    public static byte[] numberToByteArray(long longValue, int byteSize) {
        byte[] byteArray = new byte[byteSize];
        for (int i2 = 0; i2 < byteSize; ++i2) {
            byteArray[byteSize - 1 - i2] = new Long(longValue % 256L).byteValue();
            longValue >>= 8;
        }
        return byteArray;
    }

    public static byte[] longValueToByteArray(long longValue) {
        return Utils.numberToByteArray(longValue, 8);
    }

    public static byte[] intValueToByteArray(int intValue) {
        return Utils.numberToByteArray(intValue, 4);
    }

    public static byte[] shortValueToByteArray(short shortValue) {
        return Utils.numberToByteArray(shortValue, 2);
    }

    public static void showErrorMessage(Frame frame, Exception e, String title) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.toString();
        } else if (msg.length() == 0) {
            msg = e.toString();
        }
        JOptionPane.showMessageDialog(frame, msg, title, 0);
    }

    public static void centerDialog(JDialog dialog) {
        Dimension screenSize = dialog.getToolkit().getScreenSize();
        Dimension frameSize = dialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)dialog).setLocation(new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2));
    }

    public static void centerDialog(Frame frame, JDialog dialog) {
        Dimension screenSize = frame.getSize();
        Dimension frameSize = dialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)dialog).setLocation(new Point(frame.getX() + (screenSize.width - frameSize.width) / 2, frame.getY() + (screenSize.height - frameSize.height) / 2));
    }

    public static Image loadImage(Component c2, String fullPath) {
        try {
            Image image = c2.getToolkit().getImage(fullPath);
            MediaTracker tracker = new MediaTracker(c2);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            return image;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static long truncateDate(long date) {
        if (date == 0L) {
            return 0L;
        }
        Calendar tDate = Calendar.getInstance();
        tDate.setTimeInMillis(date);
        tDate.set(11, 0);
        tDate.set(12, 0);
        tDate.set(13, 0);
        tDate.set(14, 0);
        return tDate.getTimeInMillis();
    }
}

